#!/bin/sh
#
# NAG Fortran Compiler unattended installation script for running from a CD
# or unpacked tar distribution.
#
# Target installation directories must be specified via environment variables:
#
#   INSTALL_TO_BINDIR
#     the directory to contain the generated driver scripts and supporting
#     binary materials;
#   (optional) INSTALL_TO_CATMANDIR
#     the directory prefix for preformatted man pages;
#   (optional) INSTALL_TO_MANDIR
#     the directory prefix for unformatted man pages.
#
# Tozai: RUNU.sh 4926 2015-10-28 14:24:43Z mathewc
#
# Chiyoda: $Id: RUNU.sh 7880 2020-08-17 07:11:26Z Malcolm Cohen $
#
if [ -z "${INSTALL_TO_BINDIR-}" ]; then
    echo "Error: Please set INSTALL_TO_BINDIR in the environment."
    exit 1
fi
copy=cp
if [ -x /usr/bin/uname ]; then
    if [ "`uname`" = "SunOS" ]; then
        copy="${copy} -p"
    fi
fi
remove=rm
echo
echo "Welcome to the NAG Fortran Compiler RUNU.sh unattended installation" \
     "script."
echo
echo "This script installs the NAG Fortran Compiler to run using the"
echo "distribution directory, hence the installation will stop working"
echo "if you delete (or unmount) the distribution directory."
echo
if [ ! -f RUNU.sh ]; then
    echo "Error: Not within a NAG Fortran Compiler distribution directory."
    echo
    echo "Please change your working directory to the relevant"
    echo "NAG_Fortran-* distribution directory and try again."
    exit 1
fi
licence_agreement_file=nag_tsandcs.txt
if [ ! -f ${licence_agreement_file} ]; then
    echo "Error: Cannot find licence agreement file ${licence_agreement_file}"
    exit 1
fi
echo "By using this script you agree to the licence terms in the accompanying"
echo "${licence_agreement_file} file."
echo
bindir="${INSTALL_TO_BINDIR}"
if [ -f "${bindir}" ]; then
    echo "Error: ${bindir} is a normal file, not a directory."
    exit 1
fi
echo "Installing to bin directory ${bindir}"
while [ ! -d "${bindir}" ]; do
    create="${bindir}"
    parent=`dirname "${create}"`
    while [ ! -d "${parent}" -a -n "${parent}" ]; do
        create="${parent}"
        parent=`dirname "${create}"`
    done
    if mkdir "${create}"; then
        echo "Created ${create}"
    else
        echo "Error: Cannot create ${create}"
        exit 1
    fi
    chmod 755 $create
done
pwdir="`pwd`"
# Make sure we can create this:
$remove -f "${bindir}"/nagfor
echo "#!/bin/sh" >"${bindir}"/nagfor
echo "${pwdir}"/bin/nagfor '"$@"' -Qpath "${pwdir}"/lib >>"${bindir}"/nagfor
chmod 755 "${bindir}"/nagfor
$remove -f "${bindir}"/nagfmcheck
$copy bin/nagfmcheck "${bindir}"/
chmod 755 "${bindir}"/nagfmcheck
echo "Compiler installed."
echo
if [ -f bin/dbx90 ]; then
    $remove -f "${bindir}"/dbx90
    $copy bin/dbx90 "${bindir}"/
    chmod 755 "${bindir}"/dbx90
    echo "Debugger installed."
    echo
fi
for man_format in pre un; do
    if [ "${man_format}" = "pre" ]; then
        if [ -z "${INSTALL_TO_CATMANDIR-}" ]; then
            echo "Skipping installation of ${man_format}formatted man pages."
            echo
            continue
        fi
        mandir="${INSTALL_TO_CATMANDIR}"
        if [ ! -f man/nagfor.z ]; then
            echo "No ${man_format}formatted man pages to install. Continuing."
            echo
            continue
        fi
    else
        if [ -z "${INSTALL_TO_MANDIR-}" ]; then
            echo "Skipping installation of ${man_format}formatted man pages."
            echo
            continue
        fi
        mandir="${INSTALL_TO_MANDIR}"
    fi
    for manext in 1 3; do
        if [ -f "${mandir}${manext}" ]; then
            echo "Error: ${mandir}${manext} is a normal file, not a directory."
            exit 1
        fi
        if [ "${manext}" = "1" ]; then
            echo "Installing ${man_format}formatted man pages to" \
                 "directory ${mandir}${manext}"
        else
            echo "Installing ${man_format}formatted module man pages to" \
                 "directory ${mandir}${manext}"
        fi
        while [ ! -d "${mandir}${manext}" ]; do
            create="${mandir}${manext}"
            parent=`dirname "${create}"`
            while [ ! -d "${parent}" -a -n "${parent}" ]; do
                create="${parent}"
                parent=`dirname "${create}"`
            done
            if mkdir "${create}"; then
                echo "Created ${create}"
            else
                echo "Error: Cannot create ${create}"
                exit 1
            fi
        done
        if [ "${man_format}" = "pre" ]; then
            if [ "${manext}" = "1" ]; then
                $copy man/nagfor.z "${mandir}${manext}"
                if [ -f man/dbx90.z ]; then
                    $copy man/dbx90.z "${mandir}${manext}"
                fi
            else
                $copy man/f90*.z man/nag*.z man/ieee*.z "${mandir}${manext}"
            fi
        else
            $copy man/*.${manext} "${mandir}${manext}"
        fi
    done
    echo "Installed ${man_format}formatted man pages."
    echo
done
echo "Installation complete."
