#!/bin/sh
#
# NAG Fortran Compiler installation script
#
# Can install to user-specified or system-specific default locations
#
# Release 5.1: 1.5, 07/04/02
#
# Release 5.2: CDINSTALL.sh 35 2010-01-25 16:47:01Z ianh
#
# Release 5.3: CDINSTALL.sh 2619 2012-12-13 15:59:47Z ianh
#
# Release 5.3.2: INSTALL.sh 3311 2013-12-20 02:04:08Z Malcolm Cohen
#
# Hibiya: INSTALL.sh 3818 2014-07-09 08:31:03Z Malcolm Cohen
#
# Tozai: INSTALL.sh 5304 2016-07-22 01:04:12Z Malcolm Cohen
#
# Chiyoda: INSTALL.sh 6442 2018-07-15 06:06:06Z Malcolm Cohen $
#
# Yurakucho: $Id: INSTALL.sh 8120 2020-12-18 02:21:45Z Malcolm Cohen $
#
remove=rm
removedir=rmdir
removetree='rm -rf'
whoami=whoami
chown='chown -fhR'
chgrp='chgrp -fhR'
move='cp -p'
maybe_remove=:
maybe_removetree=:
installer='INSTALL.sh'
#
if [ ! -t 0 ]; then
    echo "Do 'sh $installer' not 'sh<$installer'"
    exit 1
fi
if [ ! -f $installer -o ! -d bin -o ! -d lib -o ! -d man -o ! -x bin/nagfor ]; then
    newd=`dirname $0`
    if [ -f $newd/$installer -a -d $newd/lib -a -x $newd/bin/nagfor ]; then
        echo Changing working directory to $newd...
        cd $newd
    else
        echo "Error: Cannot find NAG Fortran Compiler distribution directory"
        echo
        echo "Please change your working directory to the relevant"
        echo "NAG_Fortran-* distribution directory and try again."
        exit 1
    fi
fi
defaultlibdir=/usr/local/lib/NAG_Fortran
libdir=$defaultlibdir
bindir=/usr/local/bin
man1dir=/usr/local/man/man1
cat1dir=/usr/local/man/cat1
man1suffix=1
man3dir=/usr/local/man/man3
cat3dir=/usr/local/man/cat3
man3suffix=3
defaultlib='YES'
defaultman='YES'
preforman='NO'
if [ -x /usr/bin/uname -o -x /bin/uname ]; then
    if [ `uname` = "SunOS" ]; then
        if expr `uname -r` \>= 5.0 >/dev/null; then
            whoami=/usr/ucb/whoami
            defaultlibdir=/opt/NAG_Fortran/lib
            libdir=$defaultlibdir
            bindir=/opt/NAG_Fortran/bin
        fi
    elif [ `uname` = "HP-UX" -o `uname` = "Linux" ]; then
        chown='chown -R'
        chgrp='chgrp -R'
    fi
fi
whoami=`$whoami`
echo
echo "Welcome to the NAG Fortran Compiler Installation script!"
echo
# Work out how to write prompts without newline
(echo "hi there\c" ; echo " ") >/tmp/.echotmp
if grep c /tmp/.echotmp >/dev/null 2>&1 ; then
    n='-n'
    c=''
else
    n=''
    c='\c'
fi
$remove /tmp/.echotmp
#
#
needed_dirs=""
echo "Default answers to the questions are in square brackets [] -"
echo "just press the RETURN key to accept the default."
echo
licence_agreement_file=nag_tsandcs.txt
if [ -f ${licence_agreement_file} ]; then
    more ${licence_agreement_file}
else
    echo "Cannot find licence agreement file ${licence_agreement_file}."
    echo "NAG Fortran Compiler not installed."
    exit 1
fi
echo $n "Do you accept this licence agreement [Y]?" $c
read ans
if [ -n "$ans" -a "$ans" != "y" -a "$ans" != "Y" -a "$ans" != "Yes" -a "$ans" != "YES" -a "$ans" != "yes" ]; then
    echo "Installation declined. NAG Fortran Compiler not installed."
    exit 1
fi
echo
echo $n "Install compiler binaries to where [$bindir]?" $c
read ans
if [ -n "$ans" ]; then
    if [ "$ans" != $bindir -a `basename "$ans"` = "bin" ]; then
        newbase=`dirname "$ans"`
        defaultlib=NO
        if [ `uname` = "SunOS" ]; then
           libdir=$newbase/lib
        else
           libdir=$newbase/lib/NAG_Fortran
        fi
        man1dir=$newbase/man/man1
        man3dir=$newbase/man/man3
    fi
    bindir=$ans
fi
if [ -f $bindir ]; then
    echo $bindir is a normal file, not a directory
    exit 1
fi
case "${bindir}" in
    /* ) pathchk -- "$bindir"
         if [ $? -ne 0 ]; then
             echo "Error: Binary directory $bindir is not acceptable."
             exit 1
         fi
       ;;
    * ) echo "Error: Binary directory must be absolute path."
       exit 1
       ;;
esac
#
needed_dirs="$needed_dirs $bindir"
#
echo
echo $n "Install compiler library files to where [$libdir]?" $c
read ans
if [ -n "$ans" ]; then
    if [ "$defaultlibdir" = "$ans" ]; then
        defaultlib=YES
    else
        defaultlib=NO
    fi
    libdir=$ans
fi
if [ -f $libdir ]; then
    echo $libdir is a normal file, not a directory
    exit 1
elif [ $bindir = $libdir ]; then
    echo Library directory must be separate from binary directory.
    exit 1
fi
case "${libdir}" in
    /* ) pathchk -- "$libdir"
         if [ $? -ne 0 ]; then
             echo "Error: Library directory is not acceptable."
             exit 1
         fi
       ;;
    * ) echo "Error: Library directory must be absolute path."
       exit 1
       ;;
esac
needed_dirs="$needed_dirs $libdir"
#
if [ -f man/nagfor.z ]; then
    echo
    echo $n "Install pre-formatted man pages [Y]?" $c
    read ans
    if [ -z "$ans" -o "$ans" = "y" -o "$ans" = "Y" -o "$ans" = "Yes" -o "$ans" = "YES" -o "$ans" = "yes" ]; then
        preforman='YES'
        echo
        echo $n "Install pre-formatted compiler man pages to which directory [$cat1dir]?" $c
        read ans
        if [ -n "$ans" ]; then
            cat1dir=$ans
        fi
        if [ -f $cat1dir ]; then
            echo $cat1dir is a normal file, not a directory
            exit 1
        fi
        needed_dirs="$needed_dirs $cat1dir"
        echo
        echo $n "Install pre-formatted module man pages to which directory [$cat3dir]?" $c
        read ans
        if [ -n "$ans" ]; then
            cat3dir=$ans
        fi
        if [ -f "$cat3dir" ]; then
            echo $cat3dir is a normal file, not a directory
            exit 1
        fi
        needed_dirs="$needed_dirs $cat3dir"
        echo $n "Install unformatted man pages as well [N]?" $c
        read ans
        if [ -z "$ans" -o "$ans" != "y" -a "$ans" != "Y" -a "$ans" != "Yes" -a "$ans" != "YES" -a "$ans" != "yes" ]; then
            defaultman='NO'
        fi
    fi
fi
#
if [ $defaultman = "YES" ]; then
    echo
    echo $n "Install compiler man page to which directory [$man1dir]?" $c
    read ans
    if [ -n "$ans" ]; then
        man1dir=$ans
    fi
    if [ -f $man1dir ]; then
        echo $man1dir is a normal file, not a directory
        exit 1
    fi
    needed_dirs="$needed_dirs $man1dir"
#
    echo
    echo $n "Suffix for compiler man page [$man1suffix] (i.e. nagfor.$man1suffix)?" $c
    read ans
    if [ -n "$ans" ]; then
        man1suffix=$ans
    fi
#
    echo
    echo $n "Install module man pages to which directory [$man3dir]?" $c
    read ans
    if [ -n "$ans" ]; then
        man3dir=$ans
    fi
    if [ -f $man3dir ]; then
        echo $man3dir is a normal file, not a directory
        exit 1
    fi
    needed_dirs="$needed_dirs $man3dir"
#
    echo
    echo $n "Suffix for module man pages [$man3suffix] (i.e. f90_gc.$man3suffix)?" $c
    read ans
    if [ -n "$ans" ]; then
        man3suffix=$ans
    fi
fi
#
if [ -x $libdir/forcomp ]; then
    echo $n "Old installation found - remove contents of $libdir [Y]?" $c
    read ans
    if [ -n "$ans" -a "$ans" != "y" -a "$ans" != "Y" -a "$ans" != "Yes" -a "$ans" != "YES" -a "$ans" != "yes" ]; then
        echo $libdir contents NOT removed - attempting to overwrite...
    else
        if [ -x $libdir/UNINSTALL_NAGFOR ]; then
            $libdir/UNINSTALL_NAGFOR
            echo $libdir contents removed using UNINSTALL_NAGFOR script
        else
            $remove -rf $libdir
            echo $libdir contents removed
        fi
    fi
fi
#
if [ $whoami = "root" ]; then
    echo $n "Set ownership of files to [root]?" $c
    read ans
    if [ -n "$ans" ]; then
        owner=$ans
    else
        owner=root
    fi
    echo $n "Set group of files to [bin]?" $c
    read ans
    if [ -n "$ans" ]; then
        group=$ans
    else
        group=bin
    fi
fi
#
# Start by creating directories - must be done after UNINSTALL_NAGFOR called
newdirs=""
for i in $needed_dirs; do
    while [ ! -d $i ]; do
        create=$i
        parent=`dirname $create`
        while [ ! -d $parent -a -n "$parent" ]; do
            create=$parent
            parent=`dirname $create`
        done
        if mkdir $create; then
            echo Created $create
            newdirs="$create $newdirs"
        else
            echo Cannot create $create
            exit 1
        fi
        chmod 755 $create
    done
done
echo $n Installing $c
#
# Make sure we can create this
$remove -f $bindir/nagfor
uninstall="$libdir/UNINSTALL_NAGFOR"
$remove -f $bindir/nagfmcheck
$move bin/nagfmcheck $bindir
chmod 755 $bindir/nagfmcheck
if [ "$defaultlib" = "YES" ]; then
    $move bin/nagfor $bindir
else
    $move bin/nagfor $libdir
    echo "#!/bin/sh" >$bindir/nagfor
    echo $libdir/nagfor '"$@"' -Qpath $libdir >>$bindir/nagfor
fi
chmod 755 $bindir/nagfor
if [ -x bin/dbx90 ]; then
    $remove -f $bindir/dbx90
    if [ "$defaultlib" = "YES" ]; then
        $move bin/dbx90 $bindir
    else
        $move bin/dbx90 $libdir
        echo "#!/bin/sh" >$bindir/dbx90
        echo $libdir/dbx90 -Qpath $libdir '"$@"' >>$bindir/dbx90
    fi
    chmod 755 $bindir/dbx90
fi
$maybe_removetree bin
echo $n . $c
$move lib/forcomp $libdir
echo $n . $c
tar cf - doc html | (cd $libdir ; tar xf -)
cd lib
tar cf - . | (cd $libdir ; tar xf -)
cd ..
echo $n . $c
$maybe_removetree lib
echo $n . $c
if [ $whoami = "root" ]; then
    for i in nagfor dbx90 nagfmcheck; do
        if [ -x "$bindir/$i" ]; then
            $chown $owner $bindir/$i
            $chgrp $group $bindir/$i
        fi
    done
    $chown $owner $libdir
    $chgrp $group $libdir
fi
if [ $defaultman = "YES" ]; then
    for i in man/*.1; do
        $move $i $man1dir/`basename $i .1`.$man1suffix
        chmod 644 $man1dir/`basename $i .1`.$man1suffix
    done
    for i in man/*.3; do
        $move $i $man3dir/`basename $i .3`.$man3suffix
        chmod 644 $man3dir/`basename $i .3`.$man3suffix
    done
    if [ $whoami = "root" ]; then
        for i in man/*.1; do
            $chown $owner $man1dir/`basename $i .1`.$man1suffix
            $chgrp $group $man1dir/`basename $i .1`.$man1suffix
        done
        for i in man/*.3; do
            $chown $owner $man3dir/`basename $i .3`.$man3suffix
            $chgrp $group $man3dir/`basename $i .3`.$man3suffix
        done
    fi
fi
if [ -f man/nagfor.z ]; then
    for i in nagfor dbx90 fpp nagfmcheck; do
        $move man/$i.z $cat1dir/$i.Z
        chmod 644 $cat1dir/$i.Z
        if [ $whoami = "root" ]; then
            $chown $owner $cat1dir/$i.Z
            $chgrp $group $cat1dir/$i.Z
        fi
    done
    for i in f90_gc f90_unix f90_unix_file ieee_features \
        f90_iostat f90_unix_dir f90_unix_io nag_modules \
        f90_kind f90_unix_dirent f90_unix_proc \
        f90_preconn_io f90_unix_env ieee_arithmetic \
        f90_stat f90_unix_errno ieee_exceptions iso_fortran_env; do
        $move man/$i.z $cat3dir/$i.Z
        chmod 644 $cat3dir/$i.Z
        if [ $whoami = "root" ]; then
            $chown $owner $cat3dir/$i.Z
            $chgrp $group $cat3dir/$i.Z
        fi
    done
fi
tmp_uninstall=`mktemp -t np_INSTXXX`
sed -e "s%NAGFOR_INSTALL_LIBDIR%${libdir}%" \
    -e "s%NAGFOR_INSTALL_BINDIR%${bindir}%" \
    -e "s%REMOVE_DIR%${removedir}%" < UNINSTALL_NAGFOR_core > "${tmp_uninstall}"1
if [ ! -z "${man1dir-}" ]; then
    sed -e "s%NAGFOR_INSTALL_MAN1DIR%${man1dir}%" \
        -e "s%NAGFOR_MAN1%%g" < "${tmp_uninstall}"1 > "${tmp_uninstall}"2
else
    sed -e '/NAGFOR_INSTALL_MAN1DIR/d' \
        -e '/NAGFOR_MAN1/d' < "${tmp_uninstall}"1 > "${tmp_uninstall}"2
fi
if [ ! -z "${man3dir-}" ]; then
    sed -e "s%NAGFOR_INSTALL_MAN3DIR%${man3dir}%" \
        -e "s%NAGFOR_MAN3%%g" < "${tmp_uninstall}"2 > "${tmp_uninstall}"1
else
    sed -e '/NAGFOR_INSTALL_MAN3DIR/d' \
        -e '/NAGFOR_MAN3/d' < "${tmp_uninstall}"2 > "${tmp_uninstall}"1
fi
if [ ! -z "${newdirs-}" ]; then
    sed -e "s%NAGFOR_NEW_INSTALL_DIRS%${newdirs}%" \
        -e "s%NAGFOR_NEWDIRS%%g" < "${tmp_uninstall}"1 > "${tmp_uninstall}"2
else
    sed -e '/NAGFOR_NEWDIRS/d' < "${tmp_uninstall}"1 > "${tmp_uninstall}"2
fi
if [ "${defaultlibdir}" = "${libdir}" ]; then
    sed -e '/NAGFOR_NONDEFAULT_INSTALL_LIBDIR/d' < "${tmp_uninstall}"2 > "${tmp_uninstall}"1
else
    sed -e "s%NAGFOR_NONDEFAULT_INSTALL_LIBDIR%%g" < "${tmp_uninstall}"2 > "${tmp_uninstall}"1
fi
$maybe_removetree man
chmod 755 $bindir/dbx90 $bindir/nagfor $bindir/nagfmcheck >/dev/null 2>&1
find $libdir -type d -exec chmod 755 {} \;
find $libdir -type f -exec chmod 644 {} \;
chmod 755 $libdir/*.exe $libdir/dbx90 $libdir/cforcomp $libdir/forcomp32 $libdir/forcomp $libdir/fpp $libdir/kdongle $libdir/khostid $libdir/klcheck $libdir/kldctl $libdir/nagfor >/dev/null 2>&1
sed '2,3d' < "${tmp_uninstall}"1 > "${uninstall}_core"
sed -e "s%NAGFOR_INSTALL_LIBDIR%${libdir}%" < UNINSTALL_NAGFOR > "${tmp_uninstall}"1
sed '2,3d' < "${tmp_uninstall}"1 > "${uninstall}"
${remove} "${tmp_uninstall}"1 "${tmp_uninstall}"2
chmod 755 "${uninstall}_core" "${uninstall}"
if [ $whoami = "root" ]; then
    $chown $owner "${uninstall}_core" "${uninstall}"
    $chgrp $group "${uninstall}_core" "${uninstall}"
fi
echo
echo
echo NAG Fortran installation complete.
echo For the complete Compiler Manual, please see
echo   $libdir/doc/compiler.pdf
