/* ddbasic.h
 *
 * Basic header file for "double-double" precision library.
 *
 * Copyright 2008-2023 The Numerical Algorithms Group Ltd., Oxford, U.K.
 *
 * Release 5.2: ddbasic.h 2383 2012-09-11 08:19:05Z Malcolm Cohen
 *
 * Release 5.3.1: ddbasic.h 2478 2012-10-09 10:01:06Z Malcolm Cohen
 *
 * Hibiya: ddbasic.h 3412 2014-02-05 08:31:18Z Malcolm Cohen
 *
 * Tozai: ddbasic.h 4808 2015-09-23 08:26:30Z Malcolm Cohen
 *
 * Shin-Urayasu: $Id: ddbasic.h 9340 2023-01-31 04:49:13Z Malcolm Cohen $
 */

#ifndef DDBASIC_H_INCLUDED
#define DDBASIC_H_INCLUDED

/*
 * Basic data types.
 */
typedef struct { double hi,lo; } DDReal;
typedef struct { DDReal re,im; } DDComplex;

enum {
  atodd_NO_ERROR=0, atodd_NO_MEMORY, atodd_ONLY_SIGN_FOUND, atodd_BAD_INPUT_REAL,
  atodd_TOO_MANY_DECIMAL_SYMBOLS, atodd_BAD_INPUT_EXPONENT, atodd_REAL_INPUT_OVERFLOW,
  atodd_REAL_INPUT_UNDERFLOW, atodd_OUTPUT_STRING_TOO_SHORT, atodd_IO_ERROR,
  atodd_HEX_SIGNIFICAND_INPUT_EMBEDDED_BLANK, atodd_HEX_SIGNIFICAND_INPUT_MISSING_EXPONENT
};

DDReal CDECL __NAGf90_dd_DIVIDE_d(DDReal a,double b);
DDReal CDECL __NAGf90_dd_DIVIDE_dd(DDReal a,DDReal b);
DDComplex CDECL __NAGf90_dd_DIVIDE_ddc(DDReal,DDComplex);
DDReal CDECL __NAGf90_dd_TIMES_d(DDReal a,double b);
DDReal CDECL __NAGf90_dd_TIMES_dd(DDReal a,DDReal b);
DDReal CDECL __NAGf90_dd_pow_dd(DDReal x,DDReal y);
DDReal CDECL __NAGf90_dd_pow_i4(DDReal x,INT64 y);
DDComplex CDECL __NAGf90_ddc_DIVIDE_c(DDComplex x,Complex y);
DDComplex CDECL __NAGf90_ddc_DIVIDE_dc(DDComplex x,DComplex y);
DDComplex CDECL __NAGf90_ddc_DIVIDE_ddc(DDComplex x,DDComplex y);
DDComplex CDECL __NAGf90_ddc_pow_i4(DDComplex x,INT64 y);
DDComplex CDECL __NAGf90_ddc_pow_ddc(DDComplex x,DDComplex y);

/*
 * Elementary functions.
 */
DDReal CDECL __NAGf90_abs_ddc(const DDComplex *a);
DDReal CDECL __NAGf90_acos_dd(DDReal x);
DDComplex CDECL __NAGf90_acos_ddc(const DDComplex *x);
DDReal CDECL __NAGf90_acosh_dd(DDReal x);
DDComplex CDECL __NAGf90_acosh_ddc(const DDComplex *x);
DDReal CDECL __NAGf90_aint_dd(DDReal a);
DDReal CDECL __NAGf90_anint_dd(DDReal a);
DDReal CDECL __NAGf90_asin_dd(DDReal x);
DDComplex CDECL __NAGf90_asin_ddc(const DDComplex *x);
DDReal CDECL __NAGf90_asinh_dd(DDReal x);
DDComplex CDECL __NAGf90_asinh_ddc(const DDComplex *x);
DDReal CDECL __NAGf90_atan_dd(DDReal x);
DDComplex CDECL __NAGf90_atan_ddc(const DDComplex *x);
DDReal CDECL __NAGf90_atan2_dd(DDReal y,DDReal x);
DDReal CDECL __NAGf90_atanh_dd(DDReal x);
DDComplex CDECL __NAGf90_atanh_ddc(const DDComplex *x);
DDReal CDECL __NAGf90_bessel_j0_dd(DDReal x);
DDReal CDECL __NAGf90_bessel_j1_dd(DDReal x);
DDReal CDECL __NAGf90_bessel_jn_dd(INT64 n,DDReal x);
void CDECL __NAGf90_bessel_jn1n2_dd(INT64 n1,INT64 n2,DDReal x,DDReal *res);
DDReal CDECL __NAGf90_bessel_y0_dd(DDReal x);
DDReal CDECL __NAGf90_bessel_y1_dd(DDReal x);
DDReal CDECL __NAGf90_bessel_yn_dd(INT64 n,DDReal x);
void CDECL __NAGf90_bessel_yn1n2_dd(INT64 n1,INT64 n2,DDReal x,DDReal *res);
DDReal CDECL __NAGf90_ceiling_dd(DDReal x);
DDReal CDECL __NAGf90_copysign_dd(DDReal a,DDReal b);
DDReal CDECL __NAGf90_cos_dd(DDReal x);
DDComplex CDECL __NAGf90_cos_ddc(const DDComplex *x);
DDReal CDECL __NAGf90_cosh_dd(DDReal x);
DDComplex CDECL __NAGf90_cosh_ddc(const DDComplex *x);
DDReal CDECL __NAGf90_ddprod_d_d(double a,double b);
DDReal CDECL __NAGf90_erf_dd(DDReal x);
DDReal CDECL __NAGf90_erfc_dd(DDReal x);
DDReal CDECL __NAGf90_erfc_scaled_dd(DDReal x);
DDReal CDECL __NAGf90_exp_dd(DDReal x);
DDComplex CDECL __NAGf90_exp_ddc(const DDComplex *x);
int CDECL __NAGf90_exponent_dd(const DDReal *dd);
DDReal CDECL __NAGf90_floor_dd(DDReal x);
DDReal CDECL __NAGf90_fmod_dd(DDReal x,DDReal y);
DDReal CDECL __NAGf90_fraction_dd(DDReal x);
DDReal CDECL __NAGf90_gamma_dd(DDReal x);
DDReal CDECL __NAGf90_hypot_dd(DDReal x,DDReal y);
DDReal CDECL __NAGf90_log_gamma_dd(DDReal x);
DDReal CDECL __NAGf90_log_dd(DDReal x);
DDComplex CDECL __NAGf90_log_ddc(const DDComplex *x);
DDReal CDECL __NAGf90_log10_dd(DDReal x);
DDReal CDECL __NAGf90_modulo_dd(DDReal,DDReal);
DDReal CDECL __NAGf90_nearest_dd(DDReal x,DDReal y);
DDReal CDECL __NAGf90_norm2_dd(int,const __NAGf90_Dope *);
DDReal CDECL __NAGf90_rrspacing_dd(const DDReal *x);
DDReal CDECL __NAGf90_scale_dd(DDReal x,int n);
DDReal CDECL __NAGf90_set_exponent_dd(DDReal q,Integer4 e);
DDReal CDECL __NAGf90_sin_dd(DDReal x);
DDComplex CDECL __NAGf90_sin_ddc(const DDComplex *x);
void CDECL __NAGf90_sincos_dd(DDReal a,DDReal *sine,DDReal *cosine);
DDReal CDECL __NAGf90_sinh_dd(DDReal x);
DDComplex CDECL __NAGf90_sinh_ddc(const DDComplex *x);
DDReal CDECL __NAGf90_spacing_dd(const DDReal *x);
DDReal CDECL __NAGf90_sqrt_dd(DDReal x);
DDComplex CDECL __NAGf90_sqrt_ddc(const DDComplex *x);
DDReal CDECL __NAGf90_tan_dd(DDReal x);
DDComplex CDECL __NAGf90_tan_ddc(const DDComplex *x);
DDReal CDECL __NAGf90_tanh_dd(DDReal x);
DDComplex CDECL __NAGf90_tanh_ddc(const DDComplex *x);

#endif
