#!/bin/sh
#
# NAG Fortran Compiler installation script for running from CD
#
# Can install to user-specified or system-specific default locations
#
# Release 5.0: 1.5, 03/12/10
#
# Release 5.1: 1.1, 04/10/27
#
# Release 5.2: CDRUN.sh 35 2010-01-25 16:47:01Z ianh
#
# Release 5.3: CDRUN.sh 2337 2012-08-20 13:15:35Z ianh
#
# Release 5.3.2: RUN.sh 2829 2013-04-11 08:29:13Z Malcolm Cohen
#
# Tozai: RUN.sh 4926 2015-10-28 14:24:43Z mathewc
#
# Chiyoda: $Id: RUN.sh 7880 2020-08-17 07:11:26Z Malcolm Cohen $
#
copy=cp
remove=rm
#
if [ ! -t 0 ]; then
    echo "Do 'sh RUN.sh' not 'sh<RUN.sh'"
    exit 1
fi
# Work out how to write prompts without newline
(echo "hi there\c" ; echo " ") >/tmp/.echotmp
if grep c /tmp/.echotmp >/dev/null 2>&1 ; then
    n='-n'
    c=''
else
    n=''
    c='\c'
fi
$remove /tmp/.echotmp
echo "This script installs the NAG Fortran Compiler to run using the"
echo "distribution directory, and will therefore stop working if you"
echo "delete (or unmount) the distribution directory."
echo
echo $n "Continue [Y]?" $c
read ans
if [ -n "$ans" -a "$ans" != "y" -a "$ans" != "Y" -a "$ans" != "Yes" -a "$ans" != "YES" -a "$ans" != "yes" ]; then
    echo
    echo "Please use the INSTALL.sh script to copy the NAG Fortran Compiler"
    echo "files to the appropriate directories."
    exit 1
fi
if [ ! -f RUN.sh -o ! -d bin -o ! -d lib -o ! -d man -o ! -x bin/nagfor ]; then
    newd=`dirname $0`
    if [ -f $newd/RUN.sh -a -d $newd/lib -a -x $newd/bin/nagfor ]; then
        echo Changing working directory to $newd...
        cd $newd
    else
        echo "Error: Cannot find NAG Fortran Compiler distribution directory"
        echo
        echo "Please change your working directory to the relevant"
        echo "NAG_Fortran-* distribution directory and try again."
        exit 1
    fi
fi
bindir=/usr/local/bin
man1dir=/usr/local/man/man1
cat1dir=/usr/local/man/cat1
man1suffix=1
man3dir=/usr/local/man/man3
cat3dir=/usr/local/man/cat3
man3suffix=3
defaultlib='YES'
defaultman='YES'
if [ -x /usr/bin/uname ]; then
    if [ `uname` = "SunOS" ]; then
        copy='cp -p'
        if expr `uname -r` \>= 5.0 >/dev/null; then
            bindir=/opt/NAG_Fortran/bin
        fi
    fi
fi
echo
echo "Welcome to the NAG Fortran Compiler RUN.sh Installation script!"
echo
echo "This script installs the NAG Fortran Compiler for running directly from the CD."
echo
echo "Default answers to the questions are in square brackets [] -"
echo "just press the RETURN key to accept the default."
echo
licence_agreement_file=nag_tsandcs.txt
if [ -f ${licence_agreement_file} ]; then
    more ${licence_agreement_file}
else
    echo "Cannot find licence agreement file ${licence_agreement_file}."
    echo "NAG Fortran Compiler not installed."
    exit 1
fi
echo $n "Do you accept this licence agreement [Y]?" $c
read ans
if [ -n "$ans" -a "$ans" != "y" -a "$ans" != "Y" -a "$ans" != "Yes" -a "$ans" != "YES" -a "$ans" != "yes" ]; then
    echo "Installation declined. NAG Fortran Compiler not installed."
    exit 1
fi
echo
echo $n "Install compiler binaries to where [$bindir]?" $c
read ans
if [ -n "$ans" ]; then
    bindir=$ans
fi
if [ -f $bindir ]; then
    echo $bindir is a normal file, not a directory
    exit 1
fi
while [ ! -d $bindir ]; do
    create=$bindir
    parent=`dirname $create`
    while [ ! -d $parent -a -n "$parent" ]; do
        create=$parent
        parent=`dirname $create`
    done
    if mkdir $create; then
        echo Created $create
    else
        echo Cannot create $create
        exit 1
    fi
    chmod 755 $create
done
# Make sure we can create this
$remove -f $bindir/nagfor
#
echo "#!/bin/sh" >$bindir/nagfor
echo `pwd`/bin/nagfor '"$@"' -Qpath `pwd`/lib >>$bindir/nagfor
chmod 755 $bindir/nagfor
$remove -f $bindir/nagfmcheck
$copy bin/nagfmcheck $bindir/
chmod 755 $bindir/nagfmcheck
#
echo Compiler installed.
#
if [ -f bin/dbx90 ]; then
    $remove -f $bindir/dbx90
    $copy bin/dbx90 $bindir/
    chmod 755 $bindir/dbx90
    echo Debugger installed.
fi
if [ -f man/nagfor.z ]; then
    echo
    echo $n "Install pre-formatted man pages [Y]?" $c
    read ans
    if [ -z "$ans" -o "$ans" = "y" -o "$ans" = "Y" -o "$ans" = "Yes" -o "$ans" = "YES" -o "$ans" = "yes" ]; then
        echo
        echo $n "Install pre-formatted compiler man pages to which directory [$cat1dir]?" $c
        read ans
        if [ -n "$ans" ]; then
            cat1dir=$ans
        fi
        if [ -f $cat1dir ]; then
            echo $cat1dir is a normal file, not a directory
            exit 1
        fi
        while [ ! -d $cat1dir ]; do
            create=$cat1dir
            parent=`dirname $create`
            while [ ! -d $parent -a -n "$parent" ]; do
                create=$parent
                parent=`dirname $create`
            done
            if mkdir $create; then
                echo Created $create
            else
                echo Cannot create $create
                exit 1
            fi
        done
        echo
        echo $n "Install pre-formatted module man pages to which directory [$cat3dir]?" $c
        read ans
        if [ -n "$ans" ]; then
            cat3dir=$ans
        fi
        if [ -f "$cat3dir" ]; then
            echo $cat3dir is a normal file, not a directory
            exit 1
        fi
        while [ ! -d $cat3dir ]; do
            create=$cat3dir
            parent=`dirname $create`
            while [ ! -d $parent -a -n "$parent" ]; do
                create=$parent
                parent=`dirname $create`
            done
            if mkdir $create; then
                echo Created $create
            else
                echo Cannot create $create
                exit 1
            fi
        done
        $copy man/nagfor.z $cat1dir
        if [ -f man/dbx90.z ]; then
            $copy man/dbx90.z $cat1dir
        fi
        $copy man/f90*.z man/nag*.z man/ieee*.z $cat3dir
        echo
        echo "Pre-formatted man pages installed."
        echo
        echo $n "Install unformatted man pages as well [N]?" $c
        defaultman='NO'
    else
        echo $n "Install unformatted man pages [Y]?" $c
    fi
else
    echo
    echo $n "Install man pages [Y]?" $c
fi
#
read ans
if [ -z "$ans" ]; then
    ans=$defaultman
fi
if [ "$ans" != "y" -a "$ans" != "Y" -a "$ans" != "Yes" -a "$ans" != "YES" -a "$ans" != "yes" ]; then
    if [ -f man/nagfor.z ]; then
        echo "Unformatted man pages NOT installed."
    else
        echo Man pages NOT installed.
    fi
    echo
    echo Installation complete.
    exit 0
fi
#
echo
echo $n "Install compiler man page to which directory [$man1dir]?" $c
read ans
if [ -n "$ans" ]; then
    man1dir=$ans
fi
if [ -f $man1dir ]; then
    echo $man1dir is a normal file, not a directory
    exit 1
fi
while [ ! -d $man1dir ]; do
    create=$man1dir
    parent=`dirname $create`
    while [ ! -d $parent -a -n "$parent" ]; do
        create=$parent
        parent=`dirname $create`
    done
    if mkdir $create; then
        echo Created $create
    else
        echo Cannot create $create
        exit 1
    fi
done
#
echo
echo $n "Suffix for compiler man page [$man1suffix] (i.e. nagfor.$man1suffix)?" $c
read ans
if [ -n "$ans" ]; then
    man1suffix=$ans
fi
#
echo
echo $n "Install module man pages to which directory [$man3dir]?" $c
read ans
if [ -n "$ans" ]; then
    man3dir=$ans
fi
if [ -f $man3dir ]; then
    echo $man3dir is a normal file, not a directory
    exit 1
fi
while [ ! -d $man3dir ]; do
    create=$man3dir
    parent=`dirname $create`
    while [ ! -d $parent -a -n "$parent" ]; do
        create=$parent
        parent=`dirname $create`
    done
    if mkdir $create; then
        echo Created $create
    else
        echo Cannot create $create
        exit 1
    fi
done
#
echo
echo $n "Suffix for module man pages [$man3suffix] (i.e. f90_gc.$man3suffix)?" $c
read ans
if [ -n "$ans" ]; then
    man3suffix=$ans
fi
#
for i in man/*.1
do
    $copy $i $man1dir/`basename $i .1`.$man1suffix
done
for i in man/*.3
do
    $copy $i $man3dir/`basename $i .3`.$man3suffix
done
echo Man pages installed.
echo
echo Installation complete.
