/* dope.h
 *
 * NAG Fortran 90/95/2003/2008/2018 Dope Vector definitions.
 *
 * Copyright 1992-2022 The Numerical Algorithms Group Ltd., Oxford, U.K.
 *
 * Malcolm Cohen, November 1992.
 *
 * Release 3: 1.1, 96/10/30
 *
 * Release 4: 1.1, 98/08/25
 *
 * Release 4.1: 1.2, 01/11/20
 *
 * Release 4.4: 1.3, 04/02/20
 *
 * Release 5.1: 1.2, 05/06/15
 *
 * Release 5.2: dope.h 1 2009-12-02 02:54:28Z Malcolm Cohen
 *
 * Release 5.3: dope.h 2885 2013-05-08 08:54:08Z Malcolm Cohen
 *
 * Hibiya: dope.h 3644 2014-05-18 02:36:29Z Malcolm Cohen
 *
 * Tozai: dope.h 4948 2015-11-13 07:59:57Z Malcolm Cohen
 *
 * Chiyoda: dope.h 5954 2017-09-11 06:45:03Z Malcolm Cohen
 *
 * Yurakucho: dope.h 7200 2019-10-04 04:30:34Z Malcolm Cohen
 *
 * Hanzomon: $Id: dope.h 8889 2022-02-24 07:35:23Z Malcolm Cohen $
 */

#ifndef DOPE_H_INCLUDED
#define DOPE_H_INCLUDED
#include <stddef.h> /* For ptrdiff_t. */

#ifdef OBJECT_SIZE_64
typedef INT64 dope_Offset;
#else
typedef Integer3 dope_Offset;
#endif
#if defined(CHRLEN_SIZE_64) && defined(OBJECT_SIZE_64)
typedef INT64 dope_Chrlen;
#else
typedef Integer3 dope_Chrlen;
#endif

typedef struct {
  Char *addr;
  dope_Chrlen len;
} Substring;

typedef struct {
  Char2 *addr;
  dope_Chrlen len;
} Substring2;

typedef struct {
  Char4 *addr;
  dope_Chrlen len;
} Substring4;

typedef struct {
  Pointer addr;
  Integer4 *dtp;
  dope_Offset len;
} __NAGf90_LPDT_Pointer;

typedef struct {
  dope_Offset extent,mult,lower;
} Triplet;

typedef struct {
  Pointer addr;
  dope_Offset offset;
  Triplet dim[1];
} __NAGf90_Dope1;

typedef struct {
  Pointer addr;
  dope_Offset offset;
  Triplet dim[];
} __NAGf90_Dope;

typedef struct {
  Char *addr;
  dope_Chrlen len;
  dope_Offset offset;
  Triplet dim[1];
} __NAGf90_ChDope1;

typedef struct {
  Char *addr;
  dope_Chrlen len;
  dope_Offset offset;
  Triplet dim[];
} __NAGf90_ChDope;

/* __NAGf90_Dope vectors for new (PDT-capable) polymorphic array pointers. */

typedef struct {
  __NAGf90_Dope1 dv;
  struct __NAGf90_signature *sig;
  Integer4 *dtp;
} __NAGf90_NPDope1;

/* Scalar CLASS(*) pointer. */

typedef struct {
  union { dope_Offset len; Integer4 *dtp; } x;
  dope_Offset size;
} __NAGf90_tpinfo;

struct __NAGf90_class_star {
  Pointer addr;
  struct __NAGf90_signature *sig;
  __NAGf90_tpinfo tp;
};

/* __NAGf90_Dope vectors for CLASS(*) array pointers. */

typedef struct {
  struct __NAGf90_signature *sig;
  __NAGf90_tpinfo tp;
  __NAGf90_Dope1 dv;
} __NAGf90_CSDope1;

typedef struct {
  struct __NAGf90_signature *sig;
  __NAGf90_tpinfo tp;
  __NAGf90_Dope dv;
} __NAGf90_CSDope;

/* Coarray dope vector. */

typedef struct {
  struct __NAGf90_signature *sig;
  Integer4 *dtp;
  Pointer cobase,established;
  int *untranslate;
  int rank,corank;
  dope_Offset len,eltsize,usize;
  __NAGf90_Dope dv;
} __NAGf90_Codope;

/*
 * Miscellaneous i/o dope.
 */

typedef struct bsinfo_struct {
  int cdtype;
  dope_Offset pos,repeat;
  const struct bsinfo_struct *dt;
} BS_Info;

typedef struct {
  int bs_version;
  dope_Offset bs_size,eltsize;
  BS_Info *unused;
} BS_Header;

/*
 * Interoperability dope vector.
 */
typedef struct {
  ptrdiff_t extent,mult,lower;
} __NAGf90_CFI_Triplet;
typedef struct {
  void *addr;
  size_t eltsize;
  int version;
  int rank;
  int type;
  int attribute;
  size_t len,offset;
  Integer4 *dtp;
  struct __NAGf90_signature *sig;
  void *reserved;
  Integer4 ireserved;
  __NAGf90_CFI_Triplet dim[];
} __NAGf90_CFI_Dope;

#endif
