/* rts:nagfortran.h
 *
 * Runtime header file for NAG Fortran compiled code.
 *
 * Copyright 1991-2024 The Numerical Algorithms Group Ltd., Oxford, U.K.
 *
 * Malcolm Cohen, January 1991
 *
 * Version 2.0, November 1992.
 *
 * 1.17, 96/09/13
 *
 * Release 3: 1.15, 97/07/29
 *
 * Release 4: 1.10, 99/11/12
 *
 * Release 4.1: 1.33, 02/05/14
 *
 * Release 4.4: 1.49, 03/11/28
 *
 * Release 5.1: 1.25, 07/01/11
 *
 * Release 5.2: nagfortran.h 1 2009-12-02 02:54:28Z Malcolm Cohen
 *
 * Release 5.3: nagfortran.h 2594 2012-11-21 06:24:20Z sugimoto
 *
 * Hibiya: nagfortran.h 3683 2014-06-10 08:50:57Z Malcolm Cohen
 *
 * Tozai: nagfortran.h 5256 2016-06-30 03:37:08Z Malcolm Cohen
 *
 * Chiyoda: nagfortran.h 6464 2018-07-31 07:38:21Z Malcolm Cohen
 *
 * Yurakucho: nagfortran.h 7973 2020-10-13 07:07:41Z Malcolm Cohen
 *
 * Hanzomon: $Id: nagfortran.h 9948 2024-05-27 00:05:13Z Malcolm Cohen $
 */

#ifdef __GNUC__
#define VPure __attribute__((const))
#define Pure __attribute__((pure))
#define AllocFn __attribute__((malloc))
#define NoReturn __attribute__((noreturn))
#else
#define VPure
#define Pure
#define AllocFn
#define NoReturn
#endif

#ifdef WIN32
#define CDECL __cdecl
#else
#define CDECL
#endif

typedef char* Pointer;

#include <string.h>
#include <math.h>
#include <limits.h>
#ifdef MSWIN32
#include <float.h>
#endif
#ifdef SUNMATH
#include <sunmath.h>
#include <ieeefp.h>
#endif
#ifdef C99_FENV
#include <fenv.h>
int __NAGf90_ieee_get_flag(void);
void __NAGf90_ieee_set_flag(int);
#else
int CDECL __NAGf90_fpgetsticky(void);
int CDECL __NAGf90_fpsetsticky(int);
#endif
int CDECL __NAGf90_fpgetmask(void);
void CDECL __NAGf90_fpsetmask(int);
int CDECL __NAGf90_fpgetround(void);
void CDECL __NAGf90_fpsetround(int);
int CDECL __NAGf90_get_underflow_mode(void);
void CDECL __NAGf90_set_underflow_mode(int);
void CDECL __NAGf90_fpgetstatus_clear_flags(int [4]);
void CDECL __NAGf90_fpsetstatus_merge_flags(const int [4]);
#if defined(SUN4) && defined(BC51_OPTION)
#include "sparc_names.h"
#endif

#if defined(MSWIN32) || defined(__BORLANDC__)
#define INT64 __int64
#define UINT64 unsigned __int64
#elif defined(WIN32) && !defined(INT64)
#define INT64 long long         /* For compiling user programs. */
#endif

#if defined(UCHARTYPE)          /* Override for broken C compilers. */
typedef UCHARTYPE Char;
#elif CHAR_MIN < 0
typedef unsigned char Char;
#else
typedef char Char;
#endif
typedef char Logical1;          /* Single-byte logical */
typedef short Logical2;
typedef int Logical;
typedef INT64 Logical4;
typedef signed char Integer1;   /* Single-byte signed integer */
typedef short Integer2;         /* Two-byte signed integer */
typedef int Integer;
typedef Integer Integer3;       /* For dope.h, sigh. */
typedef unsigned int UINT32;    /* True on all the machines we know about. */
typedef INT64 Integer4;
typedef unsigned short Char2;
typedef UINT32 Char4;
typedef unsigned short __NAGf90_HReal;
typedef struct {
  float re,im;
} Complex;
typedef struct {
  double re,im;
} DComplex;
typedef struct {
  __NAGf90_HReal re,im;
} __NAGf90_HComplex;
#include "dope.h"
typedef dope_Offset Offset;
typedef dope_Chrlen Chrlen;
#include "ddbasic.h"            /* Always define DDReal et cetera. */
#ifdef NATIVE_QUADR
typedef long double __NAGf90_QReal;
typedef struct { __NAGf90_QReal re,im; } QComplex;
#endif
#include "libfm.h"              /* Fortran Maths functions. */

typedef union {
  Integer i;
  Integer4 i4;
  float r;
  double d;
  Complex c;
  DComplex dc;
#if defined(NATIVE_QUADR)
  __NAGf90_QReal q;
  QComplex qc;
#elif defined(QUADR)
  DDReal q;
  DDComplex qc;
#endif
  Logical l;
} Multiple;                     /* F77 storage-associated ENTRY. */

#if defined(_HPUX_SOURCE)
double cabs();
#endif

/* Out-of-line Complex division.
 */
VPure Complex CDECL __NAGf90_rdivc(float x,Complex y);
VPure DComplex CDECL __NAGf90_dpdivdc(double x,DComplex y);
VPure DComplex CDECL __NAGf90_cdivdc(Complex x,DComplex y);
VPure DComplex CDECL __NAGf90_dpdivc(double x,Complex y);
VPure DComplex CDECL __NAGf90_dcdivc(DComplex x,Complex y);

/* Out-of-line Exponentiation -- integer exponent.
 */
VPure Complex CDECL __NAGf90_cpowi(Complex x,Integer y);
VPure double CDECL __NAGf90_dpowi(double x,Integer y);
VPure DComplex CDECL __NAGf90_dcpowi(DComplex x,Integer y);
VPure float CDECL __NAGf90_fpowi(float x,Integer y);
VPure Integer CDECL __NAGf90_ipowi(Integer x,Integer y);
VPure Integer CDECL __NAGf90_ipowi_g(const char *,int,Integer,Integer);
VPure Integer4 CDECL __NAGf90_i4powi4(Integer4 x,Integer4 y);

/* Other out-of-line exponentiation */
VPure float CDECL __NAGf90_ipowr(Integer x,float y);
VPure double CDECL __NAGf90_ipowd(Integer x,double y);
VPure float CDECL __NAGf90_i4powr(Integer4 x,float y);
VPure double CDECL __NAGf90_i4powd(Integer4 x,double y);

/* Array Temporaries */
typedef struct {
  Integer1 *addr;
  Offset extent[7];
} __NAGf90_ArrayTemp7_Integer1;
typedef struct {
  Integer2 *addr;
  Offset extent[7];
} __NAGf90_ArrayTemp7_Integer2;
typedef struct {
  Integer *addr;
  Offset extent[7];
} __NAGf90_ArrayTemp7_Integer;
typedef struct {
  Integer4 *addr;
  Offset extent[7];
} __NAGf90_ArrayTemp7_Integer4;
typedef struct {
  __NAGf90_HReal *addr;
  Offset extent[7];
} __NAGf90_ArrayTemp7_HReal;
typedef struct {
  float *addr;
  Offset extent[7];
} __NAGf90_ArrayTemp7_Real;
typedef struct {
  double *addr;
  Offset extent[7];
} __NAGf90_ArrayTemp7_Double;
typedef struct {
  __NAGf90_HComplex *addr;
  Offset extent[7];
} __NAGf90_ArrayTemp7_HComplex;
typedef struct {
  Complex *addr;
  Offset extent[7];
} __NAGf90_ArrayTemp7_Complex;
typedef struct {
  DComplex *addr;
  Offset extent[7];
} __NAGf90_ArrayTemp7_DComplex;
#if defined(QUADR) && defined(NATIVE_QUADR)
typedef struct {
  __NAGf90_QReal *addr;
  Offset extent[7];
} __NAGf90_ArrayTemp7_QReal;
typedef struct {
  QComplex *addr;
  Offset extent[7];
} __NAGf90_ArrayTemp7_QComplex;
#endif
typedef struct {
  DDReal *addr;
  Offset extent[7];
} __NAGf90_ArrayTemp7_DDReal;
typedef struct {
  DDComplex *addr;
  Offset extent[7];
} __NAGf90_ArrayTemp7_DDComplex;
typedef struct {
  Logical1 *addr;
  Offset extent[7];
} __NAGf90_ArrayTemp7_Logical1;
typedef struct {
  Logical2 *addr;
  Offset extent[7];
} __NAGf90_ArrayTemp7_Logical2;
typedef struct {
  Logical *addr;
  Offset extent[7];
} __NAGf90_ArrayTemp7_Logical;
typedef struct {
  Logical4 *addr;
  Offset extent[7];
} __NAGf90_ArrayTemp7_Logical4;
typedef struct {
  Char *addr;
  Chrlen len;
  Offset extent[7];
} __NAGf90_ArrayTemp7_Char;
typedef __NAGf90_ArrayTemp7_Char __NAGf90_ArrayTemp7_Derived;
typedef struct {
  Char2 *addr;
  Chrlen len;
  Offset extent[7];
} __NAGf90_ArrayTemp7_Char2;
typedef struct {
  Char4 *addr;
  Chrlen len;
  Offset extent[7];
} __NAGf90_ArrayTemp7_Char4;

typedef struct {
  Pointer addr;
  Offset extent[];
} __NAGf90_ArrayTemp;
typedef struct {
  Char *addr;
  Chrlen len;
  Offset extent[];
} __NAGf90_ArrayTemp_Char;
typedef struct {
  Char2 *addr;
  Chrlen len;
  Offset extent[];
} __NAGf90_ArrayTemp_Char2;
typedef struct {
  Char4 *addr;
  Chrlen len;
  Offset extent[];
} __NAGf90_ArrayTemp_Char4;
typedef __NAGf90_ArrayTemp_Char __NAGf90_ArrayTemp_Derived;

typedef struct __NAGf90_atmp_list_elt_type {
  __NAGf90_ArrayTemp7_Integer atmp;
  struct __NAGf90_atmp_list_elt_type *next;
} ATmp_List_Elt;

typedef struct __NAGf90_atmp_list_ch_elt_type {
  __NAGf90_ArrayTemp7_Char atmp;
  struct __NAGf90_atmp_list_ch_elt_type *next;
} ATmp_List_Ch_Elt;

typedef struct {
  ATmp_List_Elt *list;
} ATmp_List_Type;

void CDECL __NAGf90_atmplist_append(ATmp_List_Type*,Pointer);
void CDECL __NAGf90_atmplist_append_ch(ATmp_List_Type*,
                                       __NAGf90_ArrayTemp7_Char*);
ATmp_List_Type CDECL __NAGf90_atmplist_create(void);
void CDECL __NAGf90_atmplist_finish(ATmp_List_Type);
void CDECL __NAGf90_atmplist_step(ATmp_List_Type*,Pointer);
void CDECL __NAGf90_atmplist_step_ch(ATmp_List_Type*,
                                     __NAGf90_ArrayTemp7_Char*);
void CDECL __NAGf90_atmplist_elt(ATmp_List_Type,Pointer,int);

/* Non-contig polymorphic array to contig polymorphic array copy. */
void CDECL __NAGf90_polyacopy(Pointer src,int rank,Pointer dst,Offset eltsize);

/* Character Operations */

void CDECL __NAGf90_chasgn(Char *,Chrlen,const Char *,Chrlen);
int CDECL __NAGf90_charcmp(const Char *,const Char *,Chrlen,Chrlen);
void CDECL __NAGf90_chfree(Substring *ssp);
void CDECL __NAGf90_line_chfree(Substring *ssp,int lineno,const char *fn);
Substring CDECL __NAGf90_cat_a2s(int,const __NAGf90_ChDope*);

/* NAMELIST */

typedef struct {
  int ncomponents;
  struct __NAGf90_type_component_description *component;
  dope_Offset size;
  struct __NAGf90_signature *typesig;
  char *typename;
  int *kinddtpi;
  int nkind;
} __NAGf90_Typedesc;

typedef struct __NAGf90_type_component_description {
  char *name;
  Offset offset;
  Offset *dims;
  int cdtype;
  Chrlen chrlen;
  __NAGf90_Typedesc *dtdesc;
  Pointer dtin,dtout;
  Integer4 *dtp;
} __NAGf90_Compdesc;

typedef struct {
  char *name;
  Pointer addr;
  Offset *dims;
  int cdtype;
  Chrlen chrlen;
  __NAGf90_Typedesc *dtdesc;
  Pointer dtin,dtout;
  Integer4 *dtp;
} __NAGf90_Vardesc;

typedef struct {
  char *name;
  __NAGf90_Vardesc **var;
  int nvars;
} __NAGf90_Namelist;

typedef struct {
  struct __NAGf90_signature *sig;
  const char *name;
  Integer4 *kind;
  Pointer proc;
} __NAGf90_Defio_Item;

/* Error Handling */

NoReturn void CDECL __NAGf90_badptr0_line(const char *,int,Pointer);
NoReturn void CDECL __NAGf90_badptr1_line(const char *,int,const char *,
                                          Pointer);
NoReturn void CDECL __NAGf90_badptr2a_line(const char *,int,const char *);
NoReturn void CDECL __NAGf90_badptr3_line(const char *,int,Pointer,char *,int);

extern const char *__NAGf90_filename;
extern int __NAGf90_lineno;
void CDECL __NAGf90_enter_pu(const char *routine);
void CDECL __NAGf90_exit_pu(void);
void CDECL __NAGf90_trace_back(Integer unit,__NAGf90_CFI_Dope *msg);
typedef struct {
  const char *filename;
  int line;
} __NAGf90_gline_location;
extern CDECL __NAGf90_gline_location * __NAGf90_enter_scope(const char *,int,const char *,int);

NoReturn void CDECL __NAGf90_rterr(const char *,int,int,...);

/* Confused-Level Storage Allocation */

void CDECL __NAGf90_DeAlloc_o(void *,Offset);
void CDECL __NAGf90_line_DeAlloc_o(void *,Offset,int,const char *);
Pointer CDECL __NAGf90_ReAlloc(Pointer,Offset,Offset,Offset);
Pointer CDECL __NAGf90_line_ReAlloc(Pointer pointer,Offset eltsize,
                                    Offset oldsize,Offset newsize,int lineno,
                                    const char *fn);

/* Top Level Allocation Routines */

Pointer AllocFn CDECL __NAGf90_Allocate_aa(Offset,Integer *);
void CDECL __NAGf90_Deallocate_aa(Pointer,const Triplet[],int,Offset,Integer*);

Pointer AllocFn CDECL __NAGf90_Allocate_s(Integer,Integer*);
Pointer AllocFn CDECL __NAGf90_Allocate_zs(Integer,Integer*);
void CDECL __NAGf90_Deallocate_p(Pointer,Offset,Integer*);
Pointer AllocFn CDECL __NAGf90_Alloc_var(Offset);
Pointer AllocFn CDECL __NAGf90_Alloc_zvar(Offset);
Pointer AllocFn CDECL __NAGf90_Alloc_atmp(Offset);
Pointer AllocFn CDECL __NAGf90_Alloc_zatmp(Offset);

Pointer AllocFn CDECL __NAGf90_line_Alloc_atmp(Offset,int,const char *);
Pointer AllocFn CDECL __NAGf90_line_Alloc_var(Offset,int,const char *);
Pointer AllocFn CDECL __NAGf90_line_Alloc_zatmp(Offset,int,const char *);
Pointer AllocFn CDECL __NAGf90_line_Alloc_zvar(Offset,int,const char *);
Pointer AllocFn CDECL __NAGf90_line_Allocate_aac(Offset size,Integer *stat,
                                                 int lineno,const char *fn);
Pointer AllocFn CDECL __NAGf90_line_Allocate_s(Offset,Integer*,int,
                                               const char *);
Pointer AllocFn CDECL __NAGf90_line_Allocate_zs(Offset,Integer*,int,
                                                const char *);
void CDECL __NAGf90_line_Deallocate_aa(Pointer addr,Triplet dim[],int rank,
                                       Integer eltsize,Integer *stat,
                                       int lineno,const char *fn);
void CDECL __NAGf90_line_Deallocate_s(Pointer,Offset,Integer *,int,
                                      const char *);
Pointer CDECL __NAGf90_Allocate_as(Offset,Integer *);
Pointer CDECL __NAGf90_Allocate_p(Offset,Integer *);
Pointer CDECL __NAGf90_Allocate_zas(Offset,Integer *);
Pointer CDECL __NAGf90_Allocate_zp(Offset,Integer *);
Pointer CDECL __NAGf90_line_Allocate_as(Offset,Integer *,int,const char *);
Pointer CDECL __NAGf90_line_Allocate_p(Offset,Integer *,int,const char *);
Pointer CDECL __NAGf90_line_Allocate_zas(Offset,Integer *,int,const char *);
Pointer CDECL __NAGf90_line_Allocate_zp(Offset,Integer *,int,const char *);

/* 5.2 memory allocation */

void CDECL __NAGf90_aDeAlloc(Pointer,Offset);
void CDECL __NAGf90_laDeAlloc(const char *,int,Pointer,Offset);
Pointer CDECL __NAGf90_aAlloc(Offset);
Pointer CDECL __NAGf90_laAlloc(Offset,int,const char *);
Pointer CDECL __NAGf90_zaAlloc(Offset);
Pointer CDECL __NAGf90_lzaAlloc(Offset,int,const char *);

/* Intrinsic Functions */

void CDECL __NAGf90_date_and_time_line(const char *,int,Char *,Char *,Char *,
                                       __NAGf90_Dope1 *,Chrlen,Chrlen,Chrlen);
void CDECL __NAGf90_date_and_time_i4_line(const char *,int,Char *,Char*,Char*,
                                          __NAGf90_Dope1 *,Chrlen,Chrlen,Chrlen);

Pure Complex CDECL __NAGf90_exp_imag(const float *);
Pure DComplex CDECL __NAGf90_exp_dimag(const double *);

VPure Integer CDECL __NAGf90_ishftc(Integer,Integer,Integer,Integer);
VPure Integer4 CDECL __NAGf90_ishftc_i4(Integer4,Integer4,Integer,Integer);

Pure Chrlen CDECL __NAGf90_len_trim1(const Char *,Chrlen);

Pure Integer CDECL __NAGf90_nint_r_i(float *);
Pure Integer CDECL __NAGf90_nint_d_i(double *);

void CDECL __NAGf90_pack_line(const char *,int,__NAGf90_ArrayTemp *,int,
                              const __NAGf90_Dope *,int,const __NAGf90_Dope *,
                              const __NAGf90_Dope1 *,Offset);
void CDECL __NAGf90_l1_pack_line(const char *,int,__NAGf90_ArrayTemp *,int,
                                 const __NAGf90_Dope *,int,
                                 const __NAGf90_Dope *,const __NAGf90_Dope1 *,
                                 Offset);
void CDECL __NAGf90_l2_pack_line(const char *,int,__NAGf90_ArrayTemp *,int,
                                 const __NAGf90_Dope *,int,
                                 const __NAGf90_Dope *,const __NAGf90_Dope1 *,
                                 Offset);
void CDECL __NAGf90_l4_pack_line(const char *,int,__NAGf90_ArrayTemp *,int,
                                 const __NAGf90_Dope *,int,
                                 const __NAGf90_Dope *,const __NAGf90_Dope1 *,
                                 Offset);
void CDECL __NAGf90_chpack_line(const char *,int,__NAGf90_ArrayTemp_Char *,int,
                                const __NAGf90_ChDope *,int,
                                const __NAGf90_Dope *,const __NAGf90_ChDope1*);
void CDECL __NAGf90_ch2pack_line(const char *,int,__NAGf90_ArrayTemp_Char2 *,
                                 int,const __NAGf90_ChDope *,int,
                                 const __NAGf90_Dope *,
                                 const __NAGf90_ChDope1*);
void CDECL __NAGf90_ch4pack_line(const char *,int,__NAGf90_ArrayTemp_Char4 *,
                                 int,const __NAGf90_ChDope *,int,
                                 const __NAGf90_Dope *,
                                 const __NAGf90_ChDope1*);
void CDECL __NAGf90_dtpack_line(const char *,int,__NAGf90_ArrayTemp_Derived *,
                                int,const __NAGf90_Dope *,int,
                                const __NAGf90_Dope *,const __NAGf90_Dope1 *,
                                Offset);
void CDECL __NAGf90_l1_chpack_line(const char *,int,__NAGf90_ArrayTemp_Char *,
                                   int,const __NAGf90_ChDope *,int,
                                   const __NAGf90_Dope *,
                                   const __NAGf90_ChDope1 *);
void CDECL __NAGf90_l1_ch2pack_line(const char *,int,__NAGf90_ArrayTemp_Char2 *,
                                    int,const __NAGf90_ChDope *,int,
                                    const __NAGf90_Dope *,
                                    const __NAGf90_ChDope1 *);
void CDECL __NAGf90_l1_ch4pack_line(const char *,int,__NAGf90_ArrayTemp_Char4 *,
                                    int,const __NAGf90_ChDope *,int,
                                    const __NAGf90_Dope *,
                                    const __NAGf90_ChDope1 *);
void CDECL __NAGf90_l1_dtpack_line(const char *,int,
                                   __NAGf90_ArrayTemp_Derived *,int,
                                   const __NAGf90_Dope *,int,
                                   const __NAGf90_Dope *,
                                   const __NAGf90_Dope1 *,Offset);
void CDECL __NAGf90_l2_chpack_line(const char *,int,__NAGf90_ArrayTemp_Char *,
                                   int,const __NAGf90_ChDope *,int,
                                   const __NAGf90_Dope*,
                                   const __NAGf90_ChDope1 *);
void CDECL __NAGf90_l2_ch2pack_line(const char *,int,__NAGf90_ArrayTemp_Char2 *,
                                    int,const __NAGf90_ChDope *,int,
                                    const __NAGf90_Dope*,
                                    const __NAGf90_ChDope1 *);
void CDECL __NAGf90_l2_ch4pack_line(const char *,int,__NAGf90_ArrayTemp_Char4 *,
                                    int,const __NAGf90_ChDope *,int,
                                    const __NAGf90_Dope*,
                                    const __NAGf90_ChDope1 *);
void CDECL __NAGf90_l2_dtpack_line(const char *,int,
                                   __NAGf90_ArrayTemp_Derived *,int,
                                   const __NAGf90_Dope *,int,
                                   const __NAGf90_Dope *,
                                   const __NAGf90_Dope1 *,Offset);
void CDECL __NAGf90_l4_chpack_line(const char *,int,__NAGf90_ArrayTemp_Char *,
                                   int,const __NAGf90_ChDope *,int,
                                   const __NAGf90_Dope *,
                                   const __NAGf90_ChDope1 *);
void CDECL __NAGf90_l4_ch2pack_line(const char *,int,__NAGf90_ArrayTemp_Char2 *,
                                    int,const __NAGf90_ChDope *,int,
                                    const __NAGf90_Dope *,
                                    const __NAGf90_ChDope1 *);
void CDECL __NAGf90_l4_ch4pack_line(const char *,int,__NAGf90_ArrayTemp_Char4 *,
                                    int,const __NAGf90_ChDope *,int,
                                    const __NAGf90_Dope *,
                                    const __NAGf90_ChDope1 *);
void CDECL __NAGf90_l4_dtpack_line(const char *,int,
                                   __NAGf90_ArrayTemp_Derived *,int,
                                   const __NAGf90_Dope *,int,
                                   const __NAGf90_Dope *,
                                   const __NAGf90_Dope1 *,Offset);

void CDECL __NAGf90_init_random52(void);
__NAGf90_HReal CDECL __NAGf90_random52_h(void);
float CDECL __NAGf90_random52_r(void);
double CDECL __NAGf90_random52_d(void);
DDReal CDECL __NAGf90_random52_dd(void);
void CDECL __NAGf90_random52a_h(int,__NAGf90_Dope *);
void CDECL __NAGf90_random52a_r(int,__NAGf90_Dope*);
void CDECL __NAGf90_random52a_d(int,__NAGf90_Dope*);
void CDECL __NAGf90_random52a_dd(int,__NAGf90_Dope*);
void CDECL __NAGf90_random52v_h(__NAGf90_HReal *,Offset);
void CDECL __NAGf90_random52v_r(float*,Offset);
void CDECL __NAGf90_random52v_d(double*,Offset);
void CDECL __NAGf90_random52v_dd(DDReal*,Offset);
void CDECL __NAGf90_random_seed_size52(Integer*);
void CDECL __NAGf90_put_random_seed52(__NAGf90_Dope1*);
void CDECL __NAGf90_get_random_seed52(const __NAGf90_Dope1*);
void CDECL __NAGf90_random_seed52(Integer*,__NAGf90_Dope1*,__NAGf90_Dope1*);
double CDECL __NAGf90_random70_d(void);
void CDECL __NAGf90_random70v_d(double dv[],Offset n);
void CDECL __NAGf90_random70a_d(int rank,__NAGf90_Dope *dv);
DDReal CDECL __NAGf90_random70_dd(void);
void CDECL __NAGf90_random70v_dd(DDReal dv[],Offset n);
void CDECL __NAGf90_random70a_dd(int rank,__NAGf90_Dope *dv);

void CDECL __NAGf90_reshape_line(const char *,int,__NAGf90_ArrayTemp*,int,
                                 const __NAGf90_Dope*,const __NAGf90_Dope1*,
                                 int,const __NAGf90_Dope *,
                                 const __NAGf90_Dope1 *,Offset);
void CDECL __NAGf90_chreshape_line(const char *,int,__NAGf90_ArrayTemp_Char *,
                                   int,const __NAGf90_ChDope *,
                                   const __NAGf90_Dope1 *,int,
                                   const __NAGf90_ChDope *,
                                   const __NAGf90_Dope1 *);
void CDECL __NAGf90_ch2reshape_line(const char *,int,__NAGf90_ArrayTemp_Char2 *,
                                    int,const __NAGf90_ChDope *,
                                    const __NAGf90_Dope1 *,int,
                                    const __NAGf90_ChDope *,
                                    const __NAGf90_Dope1 *);
void CDECL __NAGf90_ch4reshape_line(const char *,int,__NAGf90_ArrayTemp_Char4 *,
                                    int,const __NAGf90_ChDope *,
                                    const __NAGf90_Dope1 *,int,
                                    const __NAGf90_ChDope *,
                                    const __NAGf90_Dope1 *);
void CDECL __NAGf90_dtreshape_line(const char *,int,__NAGf90_ArrayTemp_Derived*,
                                   int,const __NAGf90_Dope*,
                                   const __NAGf90_Dope1*,int,
                                   const __NAGf90_Dope *,
                                   const __NAGf90_Dope1 *,Offset);

VPure Integer CDECL __NAGf90_iselect64(Integer4);
VPure Integer CDECL __NAGf90_iselectb64(Integer4);
VPure Integer CDECL __NAGf90_iselectu(Integer4);
VPure Integer CDECL __NAGf90_rselect64_radix(Integer4,Integer4,Integer4);
VPure Integer CDECL __NAGf90_rselectb64_radix(Integer4,Integer4,Integer4);
VPure Integer CDECL __NAGf90_rselectu(Integer4,Integer4,Integer4);
VPure Integer CDECL __NAGf90_ieee_rselect64_radix(Integer4,Integer4,Integer4);
VPure Integer CDECL __NAGf90_ieee_rselectb64_radix(Integer4,Integer4,Integer4);
VPure Integer CDECL __NAGf90_ieee_rselectu(Integer4,Integer4,Integer4);

Pure float CDECL __NAGf90_sign_r(float *,float *);
VPure float CDECL __NAGf90_sign90_r(float,float);

Pure double CDECL __NAGf90_sign_d(double *d,double *);
VPure double CDECL __NAGf90_sign90_d(double,double);

void CDECL __NAGf90_spread_line(const char *,int,__NAGf90_ArrayTemp *,
                                int,const __NAGf90_Dope *,Integer4,Integer4,
                                Offset);
void CDECL __NAGf90_spread_pa_line(const char *,int,__NAGf90_Dope *,int,
                                   const __NAGf90_Dope *,Integer4,Integer4,
                                   Offset);
void CDECL __NAGf90_spread_pau_line(const char *,int,__NAGf90_CSDope *,int,
                                    const __NAGf90_CSDope *,Integer4,Integer4,
                                    Offset);
void CDECL __NAGf90_spread_ps_line(const char *,int,__NAGf90_NPDope1 *,int,
                                   const struct __NAGf90_class_star *,Integer4,
                                   Integer4,Offset);
void CDECL __NAGf90_spread_psu_line(const char *,int,__NAGf90_CSDope1 *,int,
                                    const struct __NAGf90_class_star *,Integer4,
                                    Integer4,Offset);
void CDECL __NAGf90_dtspread_line(const char *,int,__NAGf90_ArrayTemp_Derived *,
                                  int,const __NAGf90_Dope *,Integer4,Integer4,
                                  Offset);
void CDECL __NAGf90_chspread_line(const char *,int,__NAGf90_ArrayTemp_Char*,int,
                                  const __NAGf90_ChDope*,Integer4,Integer4);
void CDECL __NAGf90_ch2spread_line(const char *,int,__NAGf90_ArrayTemp_Char2*,
                                   int,const __NAGf90_ChDope*,Integer4,
                                   Integer4);
void CDECL __NAGf90_ch4spread_line(const char *,int,__NAGf90_ArrayTemp_Char4*,
                                   int,const __NAGf90_ChDope*,Integer4,
                                   Integer4);

void CDECL __NAGf90_system_clock(Integer*,Integer*,Integer*);
void CDECL __NAGf90_system_clock_i4(Integer4 *,Integer4 *,Integer4 *);

/*
 * Main program initialisation/termination.
 */
void CDECL __NAGf90_cosmp_init(void (*)(void *),int,char *[],int,int,int);
void CDECL __NAGf90_nonsmp_init(void (*)(void *),int,char *[],int,int);
NoReturn void CDECL __NAGf90_finish(int);
void CDECL __NAGf90_g90_startup(void);

/*
 * Fortran environment initialisation (non-Fortran main program).
 */
void CDECL __NAGf90_rts_init(int argc,char *argv[]);
void CDECL __NAGf90_io_init(void);
void CDECL __NAGf90_io_finish(void);

NoReturn void CDECL __NAGf90_stop2015(const char *,int,int,const Char *,Chrlen,
                                      Integer,Integer,Logical);
void CDECL __NAGf90_pause(const char *);

extern int __NAGf90_popcnt_table[256];

#ifdef NATIVE_QUADR
__NAGf90_QReal CDECL __NAGf90_aint_q(const __NAGf90_QReal*);
__NAGf90_QReal CDECL __NAGf90_anint_q(const __NAGf90_QReal*);
QComplex CDECL __NAGf90_cdivqc(Complex,QComplex);
void CDECL __NAGf90_cpu_time_q(__NAGf90_QReal *);
QComplex CDECL __NAGf90_dcdivqc(DComplex,QComplex);
__NAGf90_QReal CDECL __NAGf90_fraction_q(__NAGf90_QReal);
__NAGf90_QReal CDECL __NAGf90_max_q(int n,...);
__NAGf90_QReal CDECL __NAGf90_min_q(int n,...);
QComplex CDECL __NAGf90_qcpowi(QComplex,Integer);
QComplex CDECL __NAGf90_qdivc(__NAGf90_QReal,Complex);
QComplex CDECL __NAGf90_qdivdc(__NAGf90_QReal,DComplex);
QComplex CDECL __NAGf90_qdivqc(__NAGf90_QReal,QComplex);
__NAGf90_QReal CDECL __NAGf90_qpowi(__NAGf90_QReal,Integer);
__NAGf90_QReal CDECL __NAGf90_random52_q(void);
void CDECL __NAGf90_random52a_q(int,__NAGf90_Dope*);
void CDECL __NAGf90_random52v_q(__NAGf90_QReal*,Offset);
__NAGf90_QReal CDECL __NAGf90_sign_q(const __NAGf90_QReal*,const __NAGf90_QReal*);
__NAGf90_QReal CDECL __NAGf90_sign90_q(__NAGf90_QReal,__NAGf90_QReal);
#endif

void CDECL __NAGf90_cpu_time(float *);
void CDECL __NAGf90_cpu_time_d(double *);
void CDECL __NAGf90_cpu_time_dd(DDReal *);

/* New memory allocation "stuff" */

#define __NAGf90_NQL 120        /* Number of Quick Lists */
typedef struct {
  Pointer tail;
  int remaining;
} __NAGf90_TailInfo;

extern Pointer __NAGf90_allocatable_ql2[__NAGf90_NQL];
extern __NAGf90_TailInfo __NAGf90_allocatable_tail2;
extern Pointer __NAGf90_ordinary_ql2[__NAGf90_NQL];
extern __NAGf90_TailInfo __NAGf90_ordinary_tail2;
extern Pointer __NAGf90_pointer_ql2[__NAGf90_NQL];
extern __NAGf90_TailInfo __NAGf90_pointer_tail2;
extern int __NAGf90_fast_deallocation_allowed;

void CDECL __NAGf90_associate_pointer_g(const char *,int,Pointer,size_t,
                                        const char *);
void CDECL __NAGf90_destroy_pointer_g(const char *,int,Pointer,const char *);
void CDECL __NAGf90_disassociate_target_because(Pointer t_addr,size_t t_size,
                                                int was_deallocated,int lineno,
                                                const char *filename,
                                                const char *puname);
void CDECL __NAGf90_disassociate_target(Pointer t_addr,size_t t_size);
void CDECL __NAGf90_cdangle_Dealloc_o(Pointer,Offset,int,int,const char *,
                                      const char *);
void CDECL __NAGf90_cdangle_Deallocate_aac(Pointer,Triplet[],int,Offset,
                                           Integer *,int,int,const char *,
                                           const char *);
void CDECL __NAGf90_cdangle_Deallocate_s(Pointer,Offset,Integer *,int,int,
                                         const char *);
void CDECL __NAGf90_cdangling_aDeAlloc(const char *,int,Pointer,Offset,
                                       const char *,int);
void CDECL __NAGf90_nullify_pointer(const char *,int,Pointer,const char *);
int CDECL __NAGf90_pagecolour(Pointer pointer,Offset size);

NoReturn void CDECL __NAGf90_pu_bad_cdtype_line(const char *,int,const char *,
                                                int,int);

void CDECL __NAGf90_stat_errmsg(int statval,Char *errmsg,Chrlen len);

/* New Fortran 2003 intrinsics. */

void CDECL __NAGf90_getarg(Integer *number,Char *value,Integer *length,
                           Integer *status,Chrlen value_len);
void CDECL __NAGf90_getcmd(Char *command,Integer *length,Integer *status,
                           Chrlen command_len);
void CDECL __NAGf90_getenv(const Char *name,Char *value,Integer *length,
                           Integer *status,Logical *trim_name,Chrlen name_len,
                           Chrlen value_len);
int CDECL __NAGf90_iargc(void);

/* New Fortran 2008 intrinsics. */

void CDECL __NAGf90_system(const char *,int,const Char *command,
                           const Logical *wait,Integer *exitstat,
                           Integer *cmdstat,Char *cmdmsg,Chrlen commandlen,
                           Chrlen cmdmsglen);

/* I/O. */

typedef struct __NAGf90_io_context_struct IO_context;
typedef struct __NAGf90_internal_file_struct Internal_file;

void CDECL __NAGf90_array_ifilex(Internal_file *,int,const __NAGf90_ChDope *,
                                 int);
int CDECL __NAGf90_backspace4(const char *,int,Integer4,Char *,Chrlen,int);
int CDECL __NAGf90_close4(const char *,int,Integer4,const Char *,Chrlen,
                          Char *,Chrlen,int);
int CDECL __NAGf90_do_read_namelist2(IO_context *,__NAGf90_Namelist *,int,
                                      __NAGf90_Defio_Item *);
int CDECL __NAGf90_do_write_namelist2(IO_context *,const __NAGf90_Namelist *,
                                      int,__NAGf90_Defio_Item *);
int CDECL __NAGf90_dt_formatted_read(IO_context *,Pointer,Pointer,
                                     struct __NAGf90_signature *,
                                     const Integer4 *,int);
int CDECL __NAGf90_dt_formatted_write(IO_context *,Pointer,Pointer,
                                      struct __NAGf90_signature *,
                                      const Integer4 *,int);
int CDECL __NAGf90_dt_unformatted_read(IO_context *,Pointer,Pointer,
                                       struct __NAGf90_signature *,
                                       const Integer4 *,int);
int CDECL __NAGf90_dt_unformatted_write(IO_context *,Pointer,Pointer,
                                        struct __NAGf90_signature *,
                                        const Integer4 *,int);
int CDECL __NAGf90_dusty_fmt_read_c(IO_context *,Complex *var);
int CDECL __NAGf90_dusty_fmt_read_d(IO_context *,double *var);
int CDECL __NAGf90_dusty_fmt_read_dc(IO_context *,DComplex *var);
int CDECL __NAGf90_dusty_fmt_read_dd(IO_context *,DDReal *var);
int CDECL __NAGf90_dusty_fmt_read_ddc(IO_context *,DDComplex *var);
int CDECL __NAGf90_dusty_fmt_read_h(IO_context *,__NAGf90_HReal *);
int CDECL __NAGf90_dusty_fmt_read_hc(IO_context *,__NAGf90_HComplex *);
int CDECL __NAGf90_dusty_fmt_read_i(IO_context *,Integer *var);
int CDECL __NAGf90_dusty_fmt_read_i1(IO_context *,Integer1 *var);
int CDECL __NAGf90_dusty_fmt_read_i2(IO_context *,Integer2 *var);
int CDECL __NAGf90_dusty_fmt_read_i4(IO_context *,Integer4 *var);
int CDECL __NAGf90_dusty_fmt_read_l(IO_context *,Logical *var);
int CDECL __NAGf90_dusty_fmt_read_l1(IO_context *,Logical1 *var);
int CDECL __NAGf90_dusty_fmt_read_l2(IO_context *,Logical2 *var);
int CDECL __NAGf90_dusty_fmt_read_l4(IO_context *,Logical4 *var);
#ifdef NATIVE_QUADR
int CDECL __NAGf90_dusty_fmt_read_q(IO_context *ioctx,__NAGf90_QReal *var);
int CDECL __NAGf90_dusty_fmt_read_qc(IO_context *ioctx,QComplex *var);
#endif
int CDECL __NAGf90_dusty_fmt_read_r(IO_context *,float *var);
int CDECL __NAGf90_dusty_fmt_write_c(IO_context *,Complex number);
int CDECL __NAGf90_dusty_fmt_write_d(IO_context *,double number);
int CDECL __NAGf90_dusty_fmt_write_dc(IO_context *,DComplex number);
int CDECL __NAGf90_dusty_fmt_write_dd(IO_context *,DDReal number);
int CDECL __NAGf90_dusty_fmt_write_ddc(IO_context *,DDComplex number);
int CDECL __NAGf90_dusty_fmt_write_h(IO_context *,__NAGf90_HReal);
int CDECL __NAGf90_dusty_fmt_write_hc(IO_context *,__NAGf90_HComplex);
int CDECL __NAGf90_dusty_fmt_write_i(IO_context *,Integer number);
int CDECL __NAGf90_dusty_fmt_write_i1(IO_context *,Integer1 number);
int CDECL __NAGf90_dusty_fmt_write_i2(IO_context *,Integer2 number);
int CDECL __NAGf90_dusty_fmt_write_i4(IO_context *,Integer4 number);
int CDECL __NAGf90_dusty_fmt_write_l(IO_context *,Logical test);
int CDECL __NAGf90_dusty_fmt_write_l1(IO_context *,Logical1 test);
int CDECL __NAGf90_dusty_fmt_write_l2(IO_context *,Logical2 test);
int CDECL __NAGf90_dusty_fmt_write_l4(IO_context *,Logical4 test);
#ifdef NATIVE_QUADR
int CDECL __NAGf90_dusty_fmt_write_q(IO_context *ioctx,__NAGf90_QReal number);
int CDECL __NAGf90_dusty_fmt_write_qc(IO_context *ioctx,QComplex number);
#endif
int CDECL __NAGf90_dusty_fmt_write_r(IO_context *,float number);
void CDECL __NAGf90_end_inquire(IO_context *);
int CDECL __NAGf90_end_read_internal(IO_context *);
int CDECL __NAGf90_end_read_sequential(IO_context *);
int CDECL __NAGf90_end_read_unf(IO_context *);
int CDECL __NAGf90_end_read_direct_fmt(IO_context *);
int CDECL __NAGf90_end_read_direct_unf(IO_context *);
int CDECL __NAGf90_end_write_direct_fmt(IO_context *);
int CDECL __NAGf90_end_write_direct_unf(IO_context *);
int CDECL __NAGf90_end_write_ifile(IO_context *);
int CDECL __NAGf90_end_write_sequential(IO_context *);
int CDECL __NAGf90_end_write_unf(IO_context *);
int CDECL __NAGf90_endfile4(const char*,int,Integer4,Char *,Chrlen,int);
int CDECL __NAGf90_establish_format(IO_context *,const Char *,Chrlen,int);
int CDECL __NAGf90_flush4(const char*,int,Integer4,Char *,Chrlen,int);
int CDECL __NAGf90_fmt_read_c(IO_context *,Complex *);
int CDECL __NAGf90_fmt_read_ch(IO_context *,Char *,Chrlen);
int CDECL __NAGf90_fmt_read_ch2j(IO_context *,Char2 *,Chrlen);
int CDECL __NAGf90_fmt_read_ch2u(IO_context *,Char2 *,Chrlen);
int CDECL __NAGf90_fmt_read_ch4(IO_context *,Char4 *,Chrlen);
int CDECL __NAGf90_fmt_read_d(IO_context *,double *);
int CDECL __NAGf90_fmt_read_dc(IO_context *,DComplex *);
int CDECL __NAGf90_fmt_read_dd(IO_context *,DDReal *);
int CDECL __NAGf90_fmt_read_ddc(IO_context *,DDComplex *);
int CDECL __NAGf90_fmt_read_h(IO_context *,__NAGf90_HReal *);
int CDECL __NAGf90_fmt_read_hc(IO_context *,__NAGf90_HComplex *);
int CDECL __NAGf90_fmt_read_i(IO_context *,Integer *);
int CDECL __NAGf90_fmt_read_i1(IO_context *,Integer1 *);
int CDECL __NAGf90_fmt_read_i2(IO_context *,Integer2 *);
int CDECL __NAGf90_fmt_read_i4(IO_context *,Integer4 *);
int CDECL __NAGf90_fmt_read_l(IO_context *,Integer *);
int CDECL __NAGf90_fmt_read_l1(IO_context *,Logical1 *);
int CDECL __NAGf90_fmt_read_l2(IO_context *,Logical2 *);
int CDECL __NAGf90_fmt_read_l4(IO_context *,Logical4 *);
#ifdef NATIVE_QUADR
int CDECL __NAGf90_fmt_read_q(IO_context *ioctx,__NAGf90_QReal *var);
int CDECL __NAGf90_fmt_read_qc(IO_context *ioctx,QComplex *var);
#endif
int CDECL __NAGf90_fmt_read_r(IO_context *,float *);
int CDECL __NAGf90_fmt_write_c(IO_context *,Complex number);
int CDECL __NAGf90_fmt_write_ch(IO_context *,const Char *,Chrlen);
int CDECL __NAGf90_fmt_write_ch2j(IO_context *,const Char2 *,Chrlen);
int CDECL __NAGf90_fmt_write_ch2u(IO_context *,const Char2 *,Chrlen);
int CDECL __NAGf90_fmt_write_ch4(IO_context *,const Char4 *,Chrlen);
int CDECL __NAGf90_fmt_write_d(IO_context *,double number);
int CDECL __NAGf90_fmt_write_dc(IO_context *,DComplex number);
int CDECL __NAGf90_fmt_write_dd(IO_context *,DDReal number);
int CDECL __NAGf90_fmt_write_ddc(IO_context *,DDComplex number);
int CDECL __NAGf90_fmt_write_h(IO_context *ioctx,__NAGf90_HReal number);
int CDECL __NAGf90_fmt_write_hc(IO_context *ioctx,__NAGf90_HComplex number);
int CDECL __NAGf90_fmt_write_i(IO_context *,Integer number);
int CDECL __NAGf90_fmt_write_i1(IO_context *,Integer1 number);
int CDECL __NAGf90_fmt_write_i2(IO_context *,Integer2 number);
int CDECL __NAGf90_fmt_write_i4(IO_context *,Integer4 number);
int CDECL __NAGf90_fmt_write_l(IO_context *,Logical number);
int CDECL __NAGf90_fmt_write_l1(IO_context *,Logical1 number);
int CDECL __NAGf90_fmt_write_l2(IO_context *,Logical2 number);
int CDECL __NAGf90_fmt_write_l4(IO_context *,Logical4 number);
#ifdef NATIVE_QUADR
int CDECL __NAGf90_fmt_write_q(IO_context *ioctx,__NAGf90_QReal number);
int CDECL __NAGf90_fmt_write_qc(IO_context *ioctx,QComplex number);
#endif
int CDECL __NAGf90_fmt_write_r(IO_context *,float number);
void CDECL __NAGf90_init_linput(IO_context *);
int CDECL __NAGf90_init_loutput(IO_context *);
void CDECL __NAGf90_inquire_access(IO_context *,Char *,Chrlen);
void CDECL __NAGf90_inquire_action(IO_context *,Char *,Chrlen);
void CDECL __NAGf90_inquire_asynchronous(IO_context *,Char *,Chrlen);
void CDECL __NAGf90_inquire_blank(IO_context *,Char *,Chrlen);
void CDECL __NAGf90_inquire_convert(IO_context *,Char *,Chrlen);
void CDECL __NAGf90_inquire_decimal(IO_context *,Char *,Chrlen);
void CDECL __NAGf90_inquire_delim(IO_context *,Char *,Chrlen);
void CDECL __NAGf90_inquire_direct(IO_context *,Char *,Chrlen);
void CDECL __NAGf90_inquire_encoding(IO_context *,Char *,Chrlen);
void CDECL __NAGf90_inquire_exist(IO_context *,Logical *);
int CDECL __NAGf90_inquire_file(IO_context *,const Char *,Chrlen,Logical *,
                                Char *,Chrlen,Char *,Chrlen,int);
int CDECL __NAGf90_inquire_file_line(const char *,int,IO_context *,
                                     const Char *,Chrlen,Logical *,Char *,
                                     Chrlen,Char *,Chrlen,int);
void CDECL __NAGf90_inquire_form(IO_context *,Char *,Chrlen);
void CDECL __NAGf90_inquire_formatted(IO_context *,Char *,Chrlen);
void CDECL __NAGf90_inquire_name(IO_context *,Char *,Chrlen);
void CDECL __NAGf90_inquire_name2j(IO_context *,Char2 *,Chrlen);
void CDECL __NAGf90_inquire_name2u(IO_context *,Char2 *,Chrlen);
void CDECL __NAGf90_inquire_name4(IO_context *,Char4 *,Chrlen);
void CDECL __NAGf90_inquire_named(IO_context *,Logical *);
void CDECL __NAGf90_inquire_nextrec(IO_context *,Integer4 *);
void CDECL __NAGf90_inquire_number(IO_context *,Integer4 *);
void CDECL __NAGf90_inquire_opened(IO_context *,Logical *);
void CDECL __NAGf90_inquire_pad(IO_context *,Char *,Chrlen);
int CDECL __NAGf90_inquire_pending(IO_context *,Logical *);
int CDECL __NAGf90_inquire_pending_id(IO_context *,Integer4,Logical *);
void CDECL __NAGf90_inquire_pos(IO_context *,Integer4 *);
void CDECL __NAGf90_inquire_position(IO_context *,Char *,Chrlen);
void CDECL __NAGf90_inquire_read(IO_context *,Char *,Chrlen);
void CDECL __NAGf90_inquire_readwrite(IO_context *,Char *,Chrlen);
void CDECL __NAGf90_inquire_recl(IO_context *,Integer4 *);
void CDECL __NAGf90_inquire_round(IO_context *,Char *,Chrlen);
void CDECL __NAGf90_inquire_sequential(IO_context *,Char *,Chrlen);
void CDECL __NAGf90_inquire_sign(IO_context *,Char *,Chrlen);
void CDECL __NAGf90_inquire_size(IO_context *,Integer4 *);
void CDECL __NAGf90_inquire_stream(IO_context *,Char *,Chrlen);
void CDECL __NAGf90_inquire_unformatted(IO_context *,Char *,Chrlen);
int CDECL __NAGf90_inquire_unit(IO_context *,Integer4,Char *,Chrlen,int);
int CDECL __NAGf90_inquire_unit_line(const char *,int,IO_context *,Integer4,
                                     Char *,Chrlen,int);
void CDECL __NAGf90_inquire_write(IO_context *,Char *,Chrlen);
int CDECL __NAGf90_lio_read_c(IO_context *,Complex *);
int CDECL __NAGf90_lio_read_ch(IO_context *,Char *,Chrlen);
int CDECL __NAGf90_lio_read_ch2j(IO_context *,Char2 *,Chrlen);
int CDECL __NAGf90_lio_read_ch2u(IO_context *,Char2 *,Chrlen);
int CDECL __NAGf90_lio_read_ch4(IO_context *,Char4 *,Chrlen);
int CDECL __NAGf90_lio_read_d(IO_context *,double *);
int CDECL __NAGf90_lio_read_dc(IO_context *,DComplex *);
int CDECL __NAGf90_lio_read_dd(IO_context *,DDReal *);
int CDECL __NAGf90_lio_read_ddc(IO_context *,DDComplex *);
int CDECL __NAGf90_lio_read_h(IO_context *,__NAGf90_HReal *);
int CDECL __NAGf90_lio_read_hc(IO_context *,__NAGf90_HComplex *);
int CDECL __NAGf90_lio_read_i(IO_context *,Integer *);
int CDECL __NAGf90_lio_read_i1(IO_context *,Integer1 *);
int CDECL __NAGf90_lio_read_i2(IO_context *,Integer2 *);
int CDECL __NAGf90_lio_read_i4(IO_context *,Integer4 *);
int CDECL __NAGf90_lio_read_l(IO_context *,Logical *);
int CDECL __NAGf90_lio_read_l1(IO_context *,Logical1 *);
int CDECL __NAGf90_lio_read_l2(IO_context *,Logical2 *);
int CDECL __NAGf90_lio_read_l4(IO_context *,Logical4 *);
#ifdef NATIVE_QUADR
int CDECL __NAGf90_lio_read_q(IO_context *,__NAGf90_QReal *);
int CDECL __NAGf90_lio_read_qc(IO_context *,QComplex *);
#endif
int CDECL __NAGf90_lio_read_r(IO_context *,float *);
int CDECL __NAGf90_lio_write_c(IO_context *,Complex);
int CDECL __NAGf90_lio_write_ch(IO_context *,const Char *,Chrlen);
int CDECL __NAGf90_lio_write_ch2j(IO_context *,const Char2 *,Chrlen);
int CDECL __NAGf90_lio_write_ch2u(IO_context *,const Char2 *,Chrlen);
int CDECL __NAGf90_lio_write_ch4(IO_context *,const Char4 *,Chrlen);
int CDECL __NAGf90_lio_write_d(IO_context *,double);
int CDECL __NAGf90_lio_write_dc(IO_context *,DComplex);
int CDECL __NAGf90_lio_write_dd(IO_context *,DDReal);
int CDECL __NAGf90_lio_write_ddc(IO_context *,DDComplex);
int CDECL __NAGf90_lio_write_h(IO_context *,__NAGf90_HReal);
int CDECL __NAGf90_lio_write_hc(IO_context *,__NAGf90_HComplex);
int CDECL __NAGf90_lio_write_i(IO_context *,Integer);
int CDECL __NAGf90_lio_write_i1(IO_context *,Integer1);
int CDECL __NAGf90_lio_write_i2(IO_context *,Integer2);
int CDECL __NAGf90_lio_write_i4(IO_context *,Integer4);
int CDECL __NAGf90_lio_write_l(IO_context *,Logical);
int CDECL __NAGf90_lio_write_l1(IO_context *,Logical1);
int CDECL __NAGf90_lio_write_l2(IO_context *,Logical2);
int CDECL __NAGf90_lio_write_l4(IO_context *,Logical4);
#ifdef NATIVE_QUADR
int CDECL __NAGf90_lio_write_q(IO_context *,__NAGf90_QReal);
int CDECL __NAGf90_lio_write_qc(IO_context *,QComplex);
#endif
int CDECL __NAGf90_lio_write_r(IO_context *,float);
int CDECL __NAGf90_next_edit_is_DT(IO_context *,int,int *);
typedef struct {
  Offset version;
  const Char *spec[15];
  Chrlen len[15];
} __NAGf90_open_specs;
int CDECL __NAGf90_openf4(const char *,int,Integer4,Pointer,int,const Char*,
                          Chrlen,const __NAGf90_open_specs*,const Offset*,
                          Char *,Chrlen,int);
int CDECL __NAGf90_openf4x(const char *,int,Integer4,Pointer,int,void*,Chrlen,
                           int,const __NAGf90_open_specs*,const Offset*,
                           Char *,Chrlen,int);
int CDECL __NAGf90_read_direct_fmt4(const char *,int,IO_context *,Integer4,
                                    Offset,Char *,Chrlen,int);
int CDECL __NAGf90_read_direct_unf4(const char *,int,IO_context *,Integer4,
                                    Offset,Char *,Chrlen,int);
int CDECL __NAGf90_read_internal_file(IO_context *,Internal_file *,Char *,
                                      Chrlen,int);
int CDECL __NAGf90_read_internal_file_line(const char *,int,IO_context *,
                                           Internal_file *,Char *,Chrlen,int);
int CDECL __NAGf90_read_seq4(const char *,int,IO_context*,Integer4,Integer4*,
                             Char*,Chrlen,int);
int CDECL __NAGf90_read_unf4(const char *,int,IO_context *,Integer4,Integer4 *,
                             Char *,Chrlen,int);
int CDECL __NAGf90_read_unf2_block(IO_context *,Pointer,Offset,const BS_Info *);
int CDECL __NAGf90_read_unf2_dv(IO_context *,int,Pointer,Triplet *,Offset,
                                const BS_Info *);
int CDECL __NAGf90_readu_optf4(const char *,int,Integer4,Char *,Chrlen,int,
                               Pointer,Offset,const BS_Info *);
int CDECL __NAGf90_rewind4(const char *,int,Integer4,Char *,Chrlen,int);
void CDECL __NAGf90_scalar_ifilex(Internal_file *,void *,Offset,int);
int CDECL __NAGf90_set_ioctx(IO_context*,const Char*,Chrlen,const Char*,Chrlen,
                             const Char*,Chrlen,const Char*,Chrlen,const Char*,
                             Chrlen,const Char *,Chrlen);
int CDECL __NAGf90_set_ioctx_advance(IO_context *,const Char *,Chrlen);
int CDECL __NAGf90_set_ioctx_async(IO_context *);
void CDECL __NAGf90_set_ioctx_nonadvancing(IO_context *);
int CDECL __NAGf90_set_ioctx_size(IO_context *,Integer4 *);
int CDECL __NAGf90_waitf4(const char*,int,Integer4,Integer4*,Char*,Chrlen,int);
int CDECL __NAGf90_write_ifile(IO_context *,Internal_file *,Char *,Chrlen,int);
int CDECL __NAGf90_write_ifile_line(const char *,int,IO_context *,
                                    Internal_file *,Char *,Chrlen,int);
int CDECL __NAGf90_write_seq(const char *,int,IO_context *,Integer4,Integer4 *,
                             Char *,Chrlen,int);
int CDECL __NAGf90_writeu_opt4(const char *,int,Integer4,Char *,Chrlen,int,
                               Pointer,Offset,const BS_Info *);
int CDECL __NAGf90_write_unf4(const char *,int,IO_context *,Integer4,Integer4 *,
                              Char *,Chrlen,int);
int CDECL __NAGf90_write_unf2_block(IO_context *,Pointer,Offset,
                                    const BS_Info *);
int CDECL __NAGf90_write_unf2_dv(IO_context*,int,Pointer,const Triplet*,Offset,
                                 const BS_Info *);
int CDECL __NAGf90_write_direct_fmt4(const char *,int,IO_context *,Integer4,
                                     Offset,Char *,Chrlen,int);
int CDECL __NAGf90_write_direct_unf4(const char *,int,IO_context *,Integer4,
                                     Offset,Char *,Chrlen,int);

void CDECL __NAGf90_atomic_add(const char *,int,__NAGf90_Codope *,int,INT64,Offset *,int *);
void CDECL __NAGf90_atomic_and(const char *,int,__NAGf90_Codope *,int,INT64,Offset *,int *);
void CDECL __NAGf90_atomic_cas(const char *,int,__NAGf90_Codope *,int,Offset *,Offset,Offset,int *);
void CDECL __NAGf90_atomic_define(const char *,int,__NAGf90_Codope *,int,Offset,int *);
void CDECL __NAGf90_atomic_or(const char *,int,__NAGf90_Codope *,int,INT64,Offset *,int *);
void CDECL __NAGf90_atomic_refg(const char *,int,Offset *,__NAGf90_Codope *,int,int *);
void CDECL __NAGf90_atomic_xor(const char *,int,__NAGf90_Codope *,int,INT64,Offset *,int *);

void CDECL __NAGf90_co_broadcast(const char *,int,int,void *,void *,Offset,int,void *,Integer4 *,
                                 Chrlen,Integer4,int *,Char *,Chrlen,Offset);
void CDECL __NAGf90_co_broadcasta(const char *,int,int,void *,void *,int,Triplet *,Offset,int,
                                  void *,Integer4 *,Chrlen,Integer4,int *,Char *,Chrlen);
void CDECL __NAGf90_co_max(const char *,int,int,void *,void *,int,Chrlen,Integer4 *,int *,Char *,
                           Chrlen,Offset);
void CDECL __NAGf90_co_maxa(const char *,int,int,void *,void *,int,Chrlen,Integer4 *,int *,Char *,
                            Chrlen,int,Triplet *);
void CDECL __NAGf90_co_min(const char *,int,int,void *,void *,int,Chrlen,Integer4 *,int *,Char *,
                           Chrlen,Offset);
void CDECL __NAGf90_co_mina(const char *,int,int,void *,void *,int,Chrlen,Integer4 *,int *,Char *,
                            Chrlen,int,Triplet *);
void CDECL __NAGf90_co_reduce(const char *,int,int,
                              void(*)(Pointer,Pointer,Chrlen,Integer4 *,Offset,Offset,Pointer),
                              void *,void *,void *,void *,Offset,Chrlen,Integer4 *,Integer4 *,
                              int *,Char *,Chrlen,Offset);
void CDECL __NAGf90_co_reduce_hsl(const char *,int,int,void *,
                                  void(*)(Pointer,Pointer,Pointer,Chrlen,Integer4 *,Offset,Offset,Pointer),
                                  void *,void *,void *,void *,Offset,Chrlen,Integer4 *,Integer4 *,
                                  int *,Char *,Chrlen,Offset);
void CDECL __NAGf90_co_reducea(const char *,int,int,
                              void(*)(Pointer,Pointer,Chrlen,Integer4 *,Offset,Offset,Pointer),
                              void *,void *,void *,void *,Offset,Chrlen,Integer4 *,Integer4 *,
                              int *,Char *,Chrlen,int,const Triplet[]);
void CDECL __NAGf90_co_reducea_hsl(const char *,int,int,void *,
                                   void(*)(Pointer,Pointer,Pointer,Chrlen,Integer4 *,Offset,Offset,Pointer),
                                   void *,void *,void *,void *,Offset,Chrlen,Integer4 *,Integer4 *,
                                   int *,Char *,Chrlen,int,const Triplet[]);
void CDECL __NAGf90_co_sum(const char *,int,int,void *,void *,int,Integer4 *,int *,Char *,Chrlen,Offset);
void CDECL __NAGf90_co_suma(const char *,int,int,void *,void *,int,Integer4 *,int *,Char *,Chrlen,
                            int,Triplet *);

void CDECL __NAGf90_critical_begin(Integer4 *,int *,Char *,Chrlen);
void CDECL __NAGf90_critical_end(Integer4 *);
void CDECL __NAGf90_critical_init(const char *,int,Integer4 **);

NoReturn void CDECL __NAGf90_fail_image(const char *,int);

void CDECL __NAGf90_lock_coarray(const char *,int,__NAGf90_Codope *,Logical*,int *,Char *,Chrlen);
void CDECL __NAGf90_lock_coindexed2(const char *,int,INT64,__NAGf90_Codope *,Logical*,int *,Char *,Chrlen);
void CDECL __NAGf90_unlock_coarray(const char *,int,__NAGf90_Codope *,int *,Char *,Chrlen);
void CDECL __NAGf90_unlock_coindexed2(const char *,int,INT64,__NAGf90_Codope *,int *,Char *,Chrlen);

int CDECL __NAGf90_num_images(const char *,int,Pointer);
int CDECL __NAGf90_num_images_team_number(const char *,int,INT64);

void CDECL __NAGf90_sync_all(const char *,int,int *,Char *,Chrlen);
void CDECL __NAGf90_sync_allocate(const char *fn,int ln);
void CDECL __NAGf90_sync_images(const char *,int,__NAGf90_Dope*,int,int *,Char *,Chrlen);
void CDECL __NAGf90_sync_memory(const char *,int,int *,Char *,Chrlen);
void CDECL __NAGf90_sync_team(const char *,int,void *,int *,Char *,Chrlen);

int CDECL __NAGf90_this_image(const char *,int,Pointer);

typedef void (*__NAGf90_final_subroutine)();
typedef struct {
  __NAGf90_final_subroutine final[32];
  void *reserved1,*reserved2;
  int reserved3,reserved4;
} __NAGf90_final_subroutines;
typedef struct {
  short idx;
  short bits;
  const char *name;
} __NAGf90_tparam;
typedef struct {
  int ntp;
  const __NAGf90_tparam tp[];
} __NAGf90_tpdesc;
#ifndef __NAGf90_INTPTR_T
#define __NAGf90_INTPTR_T Offset
#endif
struct __NAGf90_signature {
  int depth;
  Offset size;
  char *typename;
  void (*copyproc)();
  void (*finalise)();
  void (*initialise)();
  void (*reserved1)();
  __NAGf90_INTPTR_T extra;
  __NAGf90_final_subroutines *ufinal;
  __NAGf90_tpdesc *tpdesc;
  void *reserved3,*reserved4,*reserved5,*reserved6,*reserved7;
  void *reserved8,*reserved9;
};
extern struct __NAGf90_signature __NAGf90_I1_HEADER,__NAGf90_I2_HEADER,__NAGf90_I3_HEADER,
  __NAGf90_I4_HEADER,__NAGf90_L1_HEADER,__NAGf90_L2_HEADER,__NAGf90_L3_HEADER,__NAGf90_L4_HEADER,
  __NAGf90_R1_HEADER,__NAGf90_R2_HEADER,__NAGf90_R3_HEADER,__NAGf90_C1_HEADER,__NAGf90_C2_HEADER,
  __NAGf90_C3_HEADER,__NAGf90_CH_HEADER,__NAGf90_CH2_HEADER,__NAGf90_CH3_HEADER,
  __NAGf90_CH4_HEADER,__NAGf90_DD_HEADER,__NAGf90_DDC_HEADER,__NAGf90_H_HEADER,__NAGf90_HC_HEADER;
typedef struct {
  struct __NAGf90_signature signature;
} __NAGf90_TYPESIG_MODULE_iso_c_binding_DT_typesig;
typedef struct {
  __NAGf90_TYPESIG_MODULE_iso_c_binding_DT_typesig typesig;
} __NAGf90_SIG_MODULE_iso_c_binding_DT_sig;
extern __NAGf90_SIG_MODULE_iso_c_binding_DT_sig __NAGf90_MODULE_ISO_C_BINDING_DT_c_ptrHEADER,
  __NAGf90_MODULE_ISO_C_BINDING_DT_c_funptrHEADER,__NAGf90_MODULE_iso_c_binding_DT_c_ptrHEADER,
  __NAGf90_MODULE_iso_c_binding_DT_c_funptrHEADER;

void CDECL __NAGf90_tls_init(volatile int *);
int CDECL __NAGf90_tls_iget(int);
void CDECL __NAGf90_tls_iset(int,int);
void * CDECL __NAGf90_tls_pget(int idx);
void CDECL __NAGf90_tls_pset(int idx,void *val);
Pointer __NAGf90_cas_ptr(Pointer *,Pointer,Pointer);

typedef struct {
  volatile Offset size;
  volatile Pointer base_addr;
  Pointer initial;
  const char *name;
} __NAGf90_CoSMP_Saved_Info;
typedef struct {
  dope_Offset id;
  int *translate;
  INT64 number;
  int num_images;
} __NAGf90_Team_Info;

void CDECL __NAGf90_change_team(const char *,int,void *,Integer *,Char *,Chrlen);
void CDECL __NAGf90_coAlloc(const char *filename,int lineno,__NAGf90_Codope *codope,Integer *stat,
                            Char *errmsg,Chrlen errmsg_len);
void CDECL __NAGf90_coDealloc(const char *filename,int lineno,__NAGf90_Codope *codope,Integer *stat,
                              Char *errmsg,Chrlen errmsg_len);
Pointer CDECL __NAGf90_cosmp_get_common(__NAGf90_CoSMP_Saved_Info *,Offset,const char *);
void CDECL *__NAGf90_cosmp_get_saved(__NAGf90_CoSMP_Saved_Info *,Offset,const char *);
void CDECL __NAGf90_cosmp_get_saved_alloc_coarray(__NAGf90_CoSMP_Saved_Info *,Offset,const char *,
                                                  void *,const __NAGf90_Codope *);
void CDECL __NAGf90_cosmp_get_saved_coarray(__NAGf90_CoSMP_Saved_Info *csi,Offset size,
                                            const char *name,__NAGf90_Codope *codope);
extern CDECL __NAGf90_Team_Info *__NAGf90_current_team_info(void);
void CDECL __NAGf90_end_team(const char *,int,Integer *,Char *,Chrlen);
void CDECL __NAGf90_event_post(const char *,int,__NAGf90_Codope *,int,Integer *,Char *,Chrlen);
Integer4 CDECL __NAGf90_event_query(void *,Integer *);
void CDECL __NAGf90_event_wait(const char *,int,void *,Integer4,Integer *,Char *,Chrlen);
__NAGf90_ArrayTemp7_Integer CDECL __NAGf90_failed_images(const char *,int,void *);
void CDECL __NAGf90_form_team(const char *,int,Integer4,void *,Integer4 *,Integer *,Char *,Chrlen);
void CDECL __NAGf90_get_team(const char *,int,void *,Integer4);
extern CDECL __NAGf90_Team_Info *__NAGf90_get_team_info(const char *,int,void *);
extern CDECL __NAGf90_Team_Info *__NAGf90_get_team_number_info(const char *,int,Integer4);
Integer CDECL __NAGf90_image_status(const char *,int,INT64,void *);
__NAGf90_ArrayTemp7_Integer CDECL __NAGf90_stopped_images(const char *,int,void *);
Integer CDECL __NAGf90_team_number(const char *,int,void *);

typedef void (CDECL *__NAGf90_OpenMP_construct_procptr)(void *);
typedef struct {
  Pointer *copies,initial;
  Offset size;
  int ncopies;
} __NAGf90_OpenMP_threadpriv_info;
void CDECL __NAGf90_OpenMP_atomic_add_i1(Integer1*,Integer1);
void CDECL __NAGf90_OpenMP_atomic_add_i2(Integer2*,Integer2);
void CDECL __NAGf90_OpenMP_atomic_add_i3(Integer3*,Integer3);
void CDECL __NAGf90_OpenMP_atomic_add_i4(Integer4*,Integer4);
void CDECL __NAGf90_OpenMP_atomic_and_l1(Logical1*,Logical1);
void CDECL __NAGf90_OpenMP_atomic_and_l2(Logical2*,Logical2);
void CDECL __NAGf90_OpenMP_atomic_and_l3(Logical*,Logical);
void CDECL __NAGf90_OpenMP_atomic_and_l4(Logical4*,Logical4);
Integer1 __NAGf90_OpenMP_atomic_capture_add_i1(Integer1*,Integer1,int);
Integer2 __NAGf90_OpenMP_atomic_capture_add_i2(Integer2*,Integer2,int);
Integer3 __NAGf90_OpenMP_atomic_capture_add_i3(Integer3*,Integer3,int);
Integer4 __NAGf90_OpenMP_atomic_capture_add_i4(Integer4*,Integer4,int);
Logical1 __NAGf90_OpenMP_atomic_capture_and_l1(Logical1*,Logical1,int);
Logical2 __NAGf90_OpenMP_atomic_capture_and_l2(Logical2*,Logical2,int);
Logical __NAGf90_OpenMP_atomic_capture_and_l3(Logical*,Logical,int);
Logical4 __NAGf90_OpenMP_atomic_capture_and_l4(Logical4*,Logical4,int);
Integer1 __NAGf90_OpenMP_atomic_capture_mul_i1(Integer1*,Integer1,int);
Integer2 __NAGf90_OpenMP_atomic_capture_mul_i2(Integer2*,Integer2,int);
Integer3 __NAGf90_OpenMP_atomic_capture_mul_i3(Integer3*,Integer3,int);
Integer4 __NAGf90_OpenMP_atomic_capture_mul_i4(Integer4*,Integer4,int);
Logical1 __NAGf90_OpenMP_atomic_capture_neqv_l1(Logical1*,Logical1,int);
Logical2 __NAGf90_OpenMP_atomic_capture_neqv_l2(Logical2*,Logical2,int);
Logical __NAGf90_OpenMP_atomic_capture_neqv_l3(Logical*,Logical,int);
Logical4 __NAGf90_OpenMP_atomic_capture_neqv_l4(Logical4*,Logical4,int);
Logical1 __NAGf90_OpenMP_atomic_capture_or_l1(Logical1*,Logical1,int);
Logical2 __NAGf90_OpenMP_atomic_capture_or_l2(Logical2*,Logical2,int);
Logical __NAGf90_OpenMP_atomic_capture_or_l3(Logical*,Logical,int);
Logical4 __NAGf90_OpenMP_atomic_capture_or_l4(Logical4*,Logical4,int);
int __NAGf90_OpenMP_atomic_cas8(Integer1 *,Integer1 *,Integer1);
int __NAGf90_OpenMP_atomic_cas16(Integer2 *,Integer2 *,Integer2);
int __NAGf90_OpenMP_atomic_cas32(Integer3 *,Integer3 *,Integer3);
int __NAGf90_OpenMP_atomic_cas64(Integer4 *,Integer4 *,Integer4);
void CDECL __NAGf90_OpenMP_atomic_lock(void);
void CDECL __NAGf90_OpenMP_atomic_neqv_l1(Logical1*,Logical1);
void CDECL __NAGf90_OpenMP_atomic_neqv_l2(Logical2*,Logical2);
void CDECL __NAGf90_OpenMP_atomic_neqv_l3(Logical*,Logical);
void CDECL __NAGf90_OpenMP_atomic_neqv_l4(Logical4*,Logical4);
void CDECL __NAGf90_OpenMP_atomic_or_l1(Logical1*,Logical1);
void CDECL __NAGf90_OpenMP_atomic_or_l2(Logical2*,Logical2);
void CDECL __NAGf90_OpenMP_atomic_or_l3(Logical*,Logical);
void CDECL __NAGf90_OpenMP_atomic_or_l4(Logical4*,Logical4);
void CDECL __NAGf90_OpenMP_atomic_unlock(void);
void CDECL __NAGf90_OpenMP_barrier(void);
int CDECL __NAGf90_OpenMP_barrier_is_cancelled_parallel(int,const char *);
int CDECL __NAGf90_OpenMP_cancel_do(void);
void CDECL __NAGf90_OpenMP_cancel_parallel(void);
int CDECL __NAGf90_OpenMP_cancel_sections(void);
void CDECL __NAGf90_OpenMP_check_badprivate(const char *,int,const char *,
                                            const char *);
void __NAGf90_OpenMP_critical_begin(void *);
void __NAGf90_OpenMP_critical_end(void *);
void * CDECL __NAGf90_OpenMP_do_2(void *,INT64,INT64,INT64,int,INT64*,Offset,
                                  Pointer *,int);
void __NAGf90_OpenMP_do_cancel_wait(void);
void CDECL __NAGf90_OpenMP_do_end(void *,int);
int CDECL __NAGf90_OpenMP_do_loop_1(void *,INT64*,INT64*);
int CDECL __NAGf90_OpenMP_filter(void);
void CDECL __NAGf90_OpenMP_flpinit2(int,void*,void*,void*,INT64,Triplet*,int);
void CDECL __NAGf90_OpenMP_flush(void);
void CDECL __NAGf90_OpenMP_gbarrier(int,const char *);
Pointer CDECL __NAGf90_OpenMP_get_threadprivc(__NAGf90_OpenMP_threadpriv_info *,Offset);
void CDECL __NAGf90_OpenMP_implicit_barrier(const char *,int);
void CDECL __NAGf90_OpenMP_info(int *,int *);
int CDECL __NAGf90_OpenMP_is_cancelled_do(void);
int CDECL __NAGf90_OpenMP_is_cancelled_parallel(void);
int CDECL __NAGf90_OpenMP_is_cancelled_sections(void);
void __NAGf90_OpenMP_ordered(const char *,int);
void __NAGf90_OpenMP_ordered_end(void);
int CDECL __NAGf90_OpenMP_parallel_2(__NAGf90_OpenMP_construct_procptr,
                                     const char *,int,int,void *,int,INT64 *,
                                     Offset,Pointer);
int CDECL __NAGf90_OpenMP_section_next2(void *);
int CDECL __NAGf90_OpenMP_section_wnext(void *);
void * CDECL __NAGf90_OpenMP_sections(void *,int,Offset,Pointer*);
void CDECL __NAGf90_OpenMP_sections_endpara(void *);
void CDECL __NAGf90_OpenMP_sections_endwait(void *);
void * CDECL __NAGf90_OpenMP_sections_wait(void *,int,Offset,Pointer*);
int CDECL __NAGf90_OpenMP_single(void *);
Pointer CDECL __NAGf90_OpenMP_single_copyprivate(int,int*);
int CDECL __NAGf90_OpenMP_single_wait(void);
void CDECL __NAGf90_OpenMP_single_end_copyprivate(void);
void CDECL __NAGf90_OpenMP_single_end_copyprivate_wait(void);
void CDECL __NAGf90_OpenMP_single_endwait(void);
void CDECL __NAGf90_OpenMP_single_endwaitg(const char *,int);
void CDECL __NAGf90_OpenMP_task(__NAGf90_OpenMP_construct_procptr,const char *,
                                int,int,void *,int,int,int,int,int);
void CDECL __NAGf90_OpenMP_taskgroup(const char *,int);
void CDECL __NAGf90_OpenMP_taskwait(const char *,int);
void CDECL __NAGf90_OpenMP_taskyield(const char *,int);

#ifndef NOVALUE
extern float __NAGf90_fvalue[];
extern double __NAGf90_dvalue[];
extern DDReal __NAGf90_ddvalue[];
#ifdef NATIVE_QUADR
extern __NAGf90_QReal __NAGf90_qvalue[];
#endif
#endif

extern const int __NAGf90_icdsize[];
