/* libfm.h
 *
 * Fortran Mathematical Functions.
 *
 * Copyright 2008-2020 The Numerical Algorithms Group Ltd., Oxford, U.K.
 *
 * Release 5.2: libfm.h 381 2010-08-12 08:47:54Z Malcolm Cohen
 *
 * Release 5.3: libfm.h 2478 2012-10-09 10:01:06Z Malcolm Cohen
 *
 * Hibiya: libfm.h 3412 2014-02-05 08:31:18Z Malcolm Cohen
 *
 * Tozai: libfm.h 4839 2015-10-02 01:02:01Z malcolm
 *
 * Chiyoda: libfm.h 5322 2016-07-31 06:02:46Z Malcolm Cohen
 *
 * Yurakucho: libfm.h 6854 2019-04-16 08:11:37Z Malcolm Cohen
 *
 * Hanzomon: $Id: libfm.h 7975 2020-10-14 06:40:55Z Malcolm Cohen $
 */

#ifndef LIBFM_H_INCLUDED
#define LIBFM_H_INCLUDED

/*
 * NAG versions of maths functions.
 */
VPure double CDECL __NAGf90_acosd(double);
VPure float CDECL __NAGf90_acosf(float);
VPure double CDECL __NAGf90_acoshd(double);
VPure float CDECL __NAGf90_acoshf(float);
VPure double CDECL __NAGf90_asind(double);
VPure float CDECL __NAGf90_asinf(float);
VPure double CDECL __NAGf90_asinhd(double);
VPure float CDECL __NAGf90_asinhf(float);
VPure double CDECL __NAGf90_atand(double);
VPure float CDECL __NAGf90_atanf(float);
VPure double CDECL __NAGf90_atan2d(double,double);
VPure float CDECL __NAGf90_atan2f(float,float);
VPure double CDECL __NAGf90_atanhd(double);
VPure float CDECL __NAGf90_atanhf(float);
VPure double CDECL __NAGf90_bessel_j0d(double);
VPure float CDECL __NAGf90_bessel_j0f(float);
void CDECL __NAGf90_bessel_jn1n2d(INT64 n1,INT64 n2,double x,double *res);
void CDECL __NAGf90_bessel_jn1n2h(INT64 n164,INT64 n264,__NAGf90_HReal x,__NAGf90_HReal *y);
void CDECL __NAGf90_bessel_jn1n2f(INT64 n1,INT64 n2,float x,float *res);
VPure double CDECL __NAGf90_bessel_y0d(double);
VPure float CDECL __NAGf90_bessel_y0f(float);
VPure double CDECL __NAGf90_bessel_j1d(double);
VPure float CDECL __NAGf90_bessel_j1f(float);
VPure double CDECL __NAGf90_bessel_y1d(double);
VPure float CDECL __NAGf90_bessel_y1f(float);
void CDECL __NAGf90_bessel_yn1n2d(INT64 n1,INT64 n2,double x,double *res);
void CDECL __NAGf90_bessel_yn1n2h(INT64 n164,INT64 n264,__NAGf90_HReal x,__NAGf90_HReal *y);
void CDECL __NAGf90_bessel_yn1n2f(INT64 n1,INT64 n2,float x,float *res);
VPure __NAGf90_HReal CDECL __NAGf90_ceiling_h(__NAGf90_HReal);
VPure double CDECL __NAGf90_cosd(double);
VPure double CDECL __NAGf90_cosd_s(double);
VPure float CDECL __NAGf90_cosf(float);
VPure double CDECL __NAGf90_coshd(double);
VPure float CDECL __NAGf90_coshf(float);
VPure float CDECL __NAGf90_coshf2(float);
VPure Complex CDECL __NAGf90_cpowc(Complex,Complex);
VPure Complex CDECL __NAGf90_cpowi4(Complex x,Integer4 y);
VPure DComplex CDECL __NAGf90_dcpowi4(DComplex x,Integer4 y);
VPure double CDECL __NAGf90_dpowi4(double x,Integer4 y);
VPure double CDECL __NAGf90_erfc_d(double x);
VPure float CDECL __NAGf90_erfc_r(float x);
VPure double CDECL __NAGf90_erfc_scaled_d(double x);
VPure float CDECL __NAGf90_erfc_scaled_r(float x);
VPure double CDECL  __NAGf90_erf_d(double x);
VPure float CDECL __NAGf90_erf_r(float x);
VPure double CDECL __NAGf90_expd(double);
VPure float CDECL __NAGf90_expf(float);
VPure __NAGf90_HReal CDECL __NAGf90_floor_h(__NAGf90_HReal);
VPure float CDECL __NAGf90_fpowi4(float x,Integer4 y);
VPure double CDECL __NAGf90_gamma_d(double);
VPure float CDECL __NAGf90_gamma_r(float);
VPure double CDECL __NAGf90_hypotd(double,double);
VPure float CDECL __NAGf90_hypotf(float,float);
Integer4 CDECL __NAGf90_i4powi4_g(const char *,int,Integer4,Integer4);
VPure Integer4 CDECL __NAGf90_iceiling_h(__NAGf90_HReal,int);
VPure double CDECL __NAGf90_log_gamma_d(double);
VPure float CDECL __NAGf90_log_gamma_r(float);
VPure double CDECL __NAGf90_logd(double);
VPure float CDECL __NAGf90_logf(float);
VPure double CDECL __NAGf90_log10d(double);
VPure float CDECL __NAGf90_log10f(float);
VPure float CDECL __NAGf90_powf(float x,float y);
VPure float CDECL __NAGf90_powf_c(float x,float y);
VPure double CDECL __NAGf90_powd(double x,double y);
VPure double CDECL __NAGf90_powd_c(double x,double y);
#ifdef NATIVE_QUADR
VPure QReal CDECL __NAGf90_qpowi4(QReal,Integer4);
#endif
VPure double CDECL __NAGf90_sind(double);
VPure double CDECL __NAGf90_sind_s(double);
VPure float CDECL __NAGf90_sinf(float);
VPure double CDECL __NAGf90_sinhd(double);
VPure float CDECL __NAGf90_sinhf(float);
void CDECL __NAGf90_sincos_d(double x,double *s,double *c);
void CDECL __NAGf90_sincos_r(float x,float *s,float *c);
VPure double CDECL __NAGf90_sqrtd(double);
VPure float CDECL __NAGf90_sqrtf(float);
VPure double CDECL __NAGf90_tand(double);
VPure float CDECL __NAGf90_tanf(float);
VPure double CDECL __NAGf90_tanhd(double x);
VPure float CDECL __NAGf90_tanhf(float);
VPure float CDECL __NAGf90_tanhf2(float);

/*
 * FDLIBM versions of maths functions.
 */
VPure double CDECL __NAGf90_acos(double);
VPure double CDECL __NAGf90_asin(double);
VPure double CDECL __NAGf90_atan(double);
VPure float CDECL __NAGf90_atan_f(float);
VPure double CDECL __NAGf90_atan2(double,double);
VPure float CDECL __NAGf90_atan2_f(float,float);
VPure double CDECL __NAGf90_cos(double x);
VPure float CDECL __NAGf90_cos_f(float);
VPure double CDECL __NAGf90_cosh(double);
VPure float CDECL __NAGf90_cosh_f(float);
VPure double CDECL __NAGf90_exp(double);
VPure double CDECL __NAGf90_fmod(double,double);
VPure float CDECL __NAGf90_fmod_f(float,float);
VPure double CDECL __NAGf90_jn(INT64 n,double x);
VPure float CDECL __NAGf90_jn_f(INT64 n,float x);
VPure double CDECL __NAGf90_log(double);
VPure double CDECL __NAGf90_log10(double);
VPure double CDECL __NAGf90_pow(double,double);
VPure float CDECL __NAGf90_pow_f(float,float);
VPure double CDECL __NAGf90_sin(double x);
VPure float CDECL __NAGf90_sin_f(float);
VPure double CDECL __NAGf90_sinh(double x);
VPure float CDECL __NAGf90_sinh_f(float);
VPure double CDECL __NAGf90_sqrt(double);
VPure double CDECL __NAGf90_tan(double);
VPure float CDECL __NAGf90_tan_f(float);
VPure double CDECL __NAGf90_tanh(double x);
VPure double CDECL __NAGf90_yn(INT64 n,double x);
VPure float CDECL __NAGf90_yn_f(INT64 n,float x);

/*
 * Other, not-quite-as-mathematical, functions.
 */
void CDECL __NAGf90_aspread(Pointer,Pointer,Offset,Offset,Offset);
Pure Chrlen CDECL __NAGf90_chindex1(const Char *string,const Char *substring,
                              Chrlen stringlen,Chrlen substringlen);
Pure Chrlen CDECL __NAGf90_chindex1b(const Char *string,const Char *substring,
                               int back,Chrlen stringlen,Chrlen substringlen);
Pure Chrlen CDECL __NAGf90_chindex2(const Char2 *string,const Char2 *substring,
                              Chrlen stringlen,Chrlen substringlen);
Pure Chrlen CDECL __NAGf90_chindex2b(const Char2 *string,const Char2 *substring,
                               int back,Chrlen stringlen,Chrlen substringlen);
Pure Chrlen CDECL __NAGf90_chindex4(const Char4 *string,const Char4 *substring,
                              Chrlen stringlen,Chrlen substringlen);
Pure Chrlen CDECL __NAGf90_chindex4b(const Char4 *string,const Char4 *substring,
                               int back,Chrlen stringlen,Chrlen substringlen);
Pure int CDECL __NAGf90_cselectu(int,const Char *name,Chrlen nameLen);
void CDECL __NAGf90_cshift_x(const char *,int,int,Pointer,const Triplet[],
                             Integer4,Integer4,Pointer,Offset);
void CDECL __NAGf90_cshift_xa(const char *,int,int,Pointer,const Triplet[],int,
                              __NAGf90_Dope *,Integer4,Pointer,Offset,int);
void CDECL __NAGf90_eoshift_aa_line(const char *,int,int,__NAGf90_Dope*,
                                    Integer4,Integer4,int,__NAGf90_Dope*,
                                    Pointer,Offset);
void CDECL __NAGf90_eoshift_aaa_line(const char *,int,int,__NAGf90_Dope*,int,
                                     __NAGf90_Dope*,Integer4,int,
                                     __NAGf90_Dope*,Pointer,Offset,int);
void CDECL __NAGf90_eoshift_aas_line(const char *,int,int,__NAGf90_Dope*,int,
                                     __NAGf90_Dope*,Integer4,Pointer,Pointer,
                                     Offset,int);
void CDECL __NAGf90_eoshift_as_line(const char *,int,int,__NAGf90_Dope*,
                                    Integer4,Integer4,Pointer,Pointer,Offset);
void CDECL __NAGf90_eoshift_xaa_line(const char *,int,int,__NAGf90_ChDope*,
                                     Integer4,Integer4,int,__NAGf90_ChDope*,
                                     Pointer,Chrlen,int);
void CDECL __NAGf90_eoshift_xas_line(const char *,int,int,__NAGf90_ChDope*,
                                     Integer4,Integer4,Pointer,Chrlen,Pointer,
                                     Chrlen,int);
void CDECL __NAGf90_eoshift_xaaa_line(const char *,int,int,__NAGf90_ChDope*,
                                      int,__NAGf90_Dope*,Integer4,int,
                                      __NAGf90_ChDope*,Pointer,Chrlen,int,int);
void CDECL __NAGf90_eoshift_xaas_line(const char *,int,int,__NAGf90_ChDope*,
                                      int,__NAGf90_Dope*,Integer4,Pointer,
                                      Chrlen,Pointer,Chrlen,int,int);
Pure int CDECL __NAGf90_exponent_d(const double *x);
Pure int CDECL __NAGf90_exponent_r(const float *x);
VPure int CDECL __NAGf90_exponent_h(__NAGf90_HReal x);
Pure int CDECL __NAGf90_finddup_in_range8(Pointer v,Offset nelts,Offset step,
                                    Offset lb,Offset ub,INT64 *duplicate);
Pure int CDECL __NAGf90_finddup_in_range16(Pointer v,Offset nelts,Offset step,
                                     Offset lb,Offset ub,INT64 *duplicate);
Pure int CDECL __NAGf90_finddup_in_range32(Pointer v,Offset nelts,Offset step,
                                     Offset lb,Offset ub,INT64 *duplicate);
Pure int CDECL __NAGf90_finddup_in_range64(Pointer v,Offset nelts,Offset step,
                                     Offset lb,Offset ub,INT64 *duplicate);
VPure double CDECL __NAGf90_fraction_d(double x);
VPure float CDECL __NAGf90_fraction_r(float x);
void CDECL __NAGf90_mmr1(float *a,float *b,float *c,Offset n1,Offset n2,
                         Offset n3);
void CDECL __NAGf90_mmr2(double *a,double *b,double *c,Offset n1,Offset n2,
                         Offset n3);
void CDECL __NAGf90_mmdd(DDReal *a,DDReal *b,DDReal *c,Offset n1,Offset n2,
                         Offset n3);
void CDECL __NAGf90_mmh(__NAGf90_HReal *a,__NAGf90_HReal *b,__NAGf90_HReal *c,Offset n1,Offset n2,
                        Offset n3);
void CDECL __NAGf90_mmc1(Complex *a,Complex *b,Complex *c,Offset n1,Offset n2,
                   Offset n3);
void CDECL __NAGf90_mmc2(DComplex *a,DComplex *b,DComplex *c,Offset n1,
                         Offset n2,Offset n3);
void CDECL __NAGf90_mmddc(DDComplex *a,DDComplex *b,DDComplex *c,Offset n1,
                          Offset n2,Offset n3);
void CDECL __NAGf90_mmhc(__NAGf90_HComplex *a,__NAGf90_HComplex *b,__NAGf90_HComplex *c,Offset n1,
                         Offset n2,Offset n3);
void CDECL __NAGf90_mmi1(Integer1 *a,Integer1 *b,Integer1 *c,Offset n1,
                         Offset n2,Offset n3);
void CDECL __NAGf90_mmi2(Integer2 *a,Integer2 *b,Integer2 *c,Offset n1,
                         Offset n2,Offset n3);
void CDECL __NAGf90_mmi3(Integer3 *a,Integer3 *b,Integer3 *c,Offset n1,
                         Offset n2,Offset n3);
void CDECL __NAGf90_mmi4(Integer4 *a,Integer4 *b,Integer4 *c,Offset n1,
                         Offset n2,Offset n3);
void CDECL __NAGf90_mml1(Logical1 *a,Logical1 *b,Logical1 *c,Offset n1,
                         Offset n2,Offset n3);
void CDECL __NAGf90_mml2(Logical2 *a,Logical2 *b,Logical2 *c,Offset n1,
                         Offset n2,Offset n3);
void CDECL __NAGf90_mml3(Logical *a,Logical *b,Logical *c,Offset n1,Offset n2,
                         Offset n3);
void CDECL __NAGf90_mml4(Logical4 *a,Logical4 *b,Logical4 *c,Offset n1,
                         Offset n2,Offset n3);
void CDECL __NAGf90_mvr1(float *a,float *b,float *v,Offset n1,Offset n2);
void CDECL __NAGf90_mvr2(double *a,double *b,double *v,Offset n1,Offset n2);
void CDECL __NAGf90_mvdd(DDReal *a,DDReal *b,DDReal *v,Offset n1,Offset n2);
void CDECL __NAGf90_mvh(__NAGf90_HReal *a,__NAGf90_HReal *b,__NAGf90_HReal *v,Offset n1,Offset n2);
void CDECL __NAGf90_mvc1(Complex *a,Complex *b,Complex *v,Offset n1,Offset n2);
void CDECL __NAGf90_mvc2(DComplex *a,DComplex *b,DComplex *v,Offset n1,
                         Offset n2);
void CDECL __NAGf90_mvddc(DDComplex *a,DDComplex *b,DDComplex *v,Offset n1,
                          Offset n2);
void CDECL __NAGf90_mvhc(__NAGf90_HComplex *a,__NAGf90_HComplex *b,__NAGf90_HComplex *v,Offset n1,
                         Offset n2);
void CDECL __NAGf90_mvi1(Integer1 *a,Integer1 *b,Integer1 *v,Offset n1,
                         Offset n2);
void CDECL __NAGf90_mvi2(Integer2 *a,Integer2 *b,Integer2 *v,Offset n1,
                         Offset n2);
void CDECL __NAGf90_mvi3(Integer3 *a,Integer3 *b,Integer3 *v,Offset n1,
                         Offset n2);
void CDECL __NAGf90_mvi4(Integer4 *a,Integer4 *b,Integer4 *v,Offset n1,
                         Offset n2);
void CDECL __NAGf90_mvl1(Logical1 *a,Logical1 *b,Logical1 *v,Offset n1,
                         Offset n2);
void CDECL __NAGf90_mvl2(Logical2 *a,Logical2 *b,Logical2 *v,Offset n1,
                         Offset n2);
void CDECL __NAGf90_mvl3(Logical *a,Logical *b,Logical *v,Offset n1,Offset n2);
void CDECL __NAGf90_mvl4(Logical4 *a,Logical4 *b,Logical4 *v,Offset n1,
                         Offset n2);
void CDECL __NAGf90_vmr1(float *a,float *v,float *c,Offset n2,Offset n3);
void CDECL __NAGf90_vmr2(double *a,double *v,double *c,Offset n2,Offset n3);
void CDECL __NAGf90_vmdd(DDReal *a,DDReal *v,DDReal *c,Offset n2,Offset n3);
void CDECL __NAGf90_vmh(__NAGf90_HReal *a,__NAGf90_HReal *v,__NAGf90_HReal *c,Offset n2,Offset n3);
void CDECL __NAGf90_vmc1(Complex *a,Complex *v,Complex *c,Offset n2,Offset n3);
void CDECL __NAGf90_vmc2(DComplex *a,DComplex *v,DComplex *c,Offset n2,
                         Offset n3);
void CDECL __NAGf90_vmhc(__NAGf90_HComplex *a,__NAGf90_HComplex *v,__NAGf90_HComplex *c,Offset n2,
                         Offset n3);
void CDECL __NAGf90_vmddc(DDComplex *a,DDComplex *v,DDComplex *c,Offset n2,
                          Offset n3);
void CDECL __NAGf90_vmi1(Integer1 *a,Integer1 *v,Integer1 *c,Offset n2,
                         Offset n3);
void CDECL __NAGf90_vmi2(Integer2 *a,Integer2 *v,Integer2 *c,Offset n2,
                         Offset n3);
void CDECL __NAGf90_vmi3(Integer3 *a,Integer3 *v,Integer3 *c,Offset n2,
                         Offset n3);
void CDECL __NAGf90_vmi4(Integer4 *a,Integer4 *v,Integer4 *c,Offset n2,
                         Offset n3);
void CDECL __NAGf90_vml1(Logical1 *a,Logical1 *v,Logical1 *c,Offset n2,
                         Offset n3);
void CDECL __NAGf90_vml2(Logical2 *a,Logical2 *v,Logical2 *c,Offset n2,
                         Offset n3);
void CDECL __NAGf90_vml3(Logical *a,Logical *v,Logical *c,Offset n2,Offset n3);
void CDECL __NAGf90_vml4(Logical4 *a,Logical4 *v,Logical4 *c,Offset n2,
                         Offset n3);
#ifdef NATIVE_QUADR
void CDECL __NAGf90_mmq(QReal *a,QReal *b,QReal *c,Offset n1,Offset n2,
                        Offset n3);
void CDECL __NAGf90_mmqc(QComplex *a,QComplex *b,QComplex *c,Offset n1,
                         Offset n2,Offset n3);
void CDECL __NAGf90_mvq(QReal *a,QReal *b,QReal *v,Offset n1,Offset n2);
void CDECL __NAGf90_mvqc(QComplex *a,QComplex *b,QComplex *v,Offset n1,
                         Offset n2);
void CDECL __NAGf90_vmq(QReal *a,QReal *v,QReal *c,Offset n2,Offset n3);
void CDECL __NAGf90_vmqc(QComplex *a,QComplex *v,QComplex *c,Offset n2,
                         Offset n3);
#endif
VPure __NAGf90_HReal CDECL __NAGf90_nearest_h(__NAGf90_HReal x,__NAGf90_HReal s);
VPure float CDECL __NAGf90_nearest_f(float x,float s);
VPure double CDECL __NAGf90_nearest_d(double x,double s);
Pure float CDECL __NAGf90_norm2_h(int,const __NAGf90_Dope *);
Pure float CDECL __NAGf90_norm2_r(int,const __NAGf90_Dope *);
Pure double CDECL __NAGf90_norm2_d(int,const __NAGf90_Dope *);
VPure __NAGf90_HReal CDECL __NAGf90_rrspacing_h(__NAGf90_HReal x);
Pure float CDECL __NAGf90_rrspacing_r(const float *);
Pure double CDECL __NAGf90_rrspacing_d(const double *);
VPure double CDECL __NAGf90_scale_d(double x,int i);
VPure float CDECL __NAGf90_scale_r(float,int);
VPure __NAGf90_HReal __NAGf90_set_exponent_h(__NAGf90_HReal x,INT64 i64);
VPure float CDECL __NAGf90_set_exponent_r(float f,INT64 i);
VPure double CDECL __NAGf90_set_exponent_d(double d,INT64 i);
Pure Char4 CDECL __NAGf90_sjis2_to_ucs4(Char2,Char4 *);
VPure __NAGf90_HReal CDECL __NAGf90_spacing_h(__NAGf90_HReal x);
Pure float CDECL __NAGf90_spacing_r(const float *);
Pure double CDECL __NAGf90_spacing_d(const double *);
Pure int CDECL __NAGf90_str_eq_keyw(const Char *,Chrlen,const char *);
int CDECL __NAGf90_multiply_i64_by_i64(INT64 *xp,INT64 y);
Pure Chrlen CDECL __NAGf90_scan(const Char *,const Char *,Chrlen,Chrlen);
Pure Chrlen CDECL __NAGf90_scan2(const Char2 *,const Char2 *,Chrlen,Chrlen);
Pure Chrlen CDECL __NAGf90_scan2b(const Char2*,const Char2*,int,Chrlen,Chrlen);
Pure Chrlen CDECL __NAGf90_scan3(const Char*,const Char*,Logical,Chrlen,Chrlen);
Pure Chrlen CDECL __NAGf90_scan4(const Char4 *,const Char4 *,Chrlen,Chrlen);
Pure Chrlen CDECL __NAGf90_scan4b(const Char4*,const Char4*,int,Chrlen,Chrlen);
void CDECL __NAGf90_transpose(Pointer xaddr,Pointer yaddr,Offset n,Offset m,
                              Offset eltsize,Offset xstep0,Offset xstep1,
                              Offset ystep0,Offset ystep1);
void CDECL __NAGf90_transpose_ch1(Pointer xaddr,Pointer yaddr,Offset n,
                                  Offset m,Chrlen xlen,Chrlen ylen,
                                  Offset xstep0,Offset xstep1,Offset ystep0,
                                  Offset ystep1);
void CDECL __NAGf90_transpose_ch2(Pointer xaddr,Pointer yaddr,Offset n,
                                  Offset m,Chrlen xlen,Chrlen ylen,
                                  Offset xstep0,Offset xstep1,Offset ystep0,
                                  Offset ystep1);
void CDECL __NAGf90_transpose_ch4(Pointer xaddr,Pointer yaddr,Offset n,
                                  Offset m,Chrlen xlen,Chrlen ylen,
                                  Offset xstep0,Offset xstep1,Offset ystep0,
                                  Offset ystep1);
Pure Char2 CDECL __NAGf90_ucs4_to_sjis2(Char4);
Pure Chrlen CDECL __NAGf90_verify(const Char *,const Char *,Chrlen,Chrlen);
Pure Chrlen CDECL __NAGf90_verify2(const Char2 *,const Char2 *,Chrlen,Chrlen);
Pure Chrlen CDECL __NAGf90_verify2b(const Char2 *,const Char2 *,int,Chrlen,
                                    Chrlen);
Pure Chrlen CDECL __NAGf90_verify3(const Char *,const Char *,Logical,Chrlen,
                                   Chrlen);
Pure Chrlen CDECL __NAGf90_verify4(const Char4 *,const Char4 *,Chrlen,Chrlen);
Pure Chrlen CDECL __NAGf90_verify4b(const Char4 *,const Char4 *,int,Chrlen,
                                    Chrlen);

/*
 * Complex arithmetic support.
 */
VPure __NAGf90_HComplex CDECL __NAGf90_hcdivhc(__NAGf90_HComplex x,__NAGf90_HComplex y);
VPure __NAGf90_HComplex CDECL __NAGf90_hcpowhc(__NAGf90_HComplex x,__NAGf90_HComplex y);
VPure __NAGf90_HComplex CDECL __NAGf90_hcpowi4(__NAGf90_HComplex x,Integer4 y);
VPure Complex CDECL __NAGf90_cdivc(Complex x,Complex y);
VPure DComplex CDECL __NAGf90_dcdivdc(DComplex x,DComplex y);
VPure DComplex CDECL __NAGf90_dcpowdc(DComplex,DComplex);
#ifdef NATIVE_QUADR
QComplex CDECL __NAGf90_qcdivc(QComplex,Complex);
QComplex CDECL __NAGf90_qcdivdc(QComplex,DComplex);
QComplex CDECL __NAGf90_qcdivqc(QComplex,QComplex);
QComplex CDECL __NAGf90_qcpowi4(QComplex,Integer4);
QComplex CDECL __NAGf90_qcpowqc(QComplex,QComplex);
#endif

/*
 * Complex intrinsics.
 */

float CDECL __NAGf90_abs_c(const Complex *);
double CDECL __NAGf90_abs_dc(const DComplex *);
Pure Complex CDECL __NAGf90_acos_c(const Complex *);
Pure DComplex CDECL __NAGf90_acos_dc(const DComplex *);
Pure __NAGf90_HComplex CDECL __NAGf90_acos_hc(__NAGf90_HComplex);
Pure Complex CDECL __NAGf90_acosh_c(const Complex *);
Pure DComplex CDECL __NAGf90_acosh_dc(const DComplex *);
Pure __NAGf90_HComplex CDECL __NAGf90_acosh_hc(__NAGf90_HComplex);
Pure Complex CDECL __NAGf90_asin_c(const Complex *);
Pure DComplex CDECL __NAGf90_asin_dc(const DComplex *);
Pure __NAGf90_HComplex CDECL __NAGf90_asin_hc(__NAGf90_HComplex);
Pure Complex CDECL __NAGf90_asinh_c(const Complex *);
Pure DComplex CDECL __NAGf90_asinh_dc(const DComplex *);
Pure __NAGf90_HComplex CDECL __NAGf90_asinh_hc(__NAGf90_HComplex);
Pure Complex CDECL __NAGf90_atan_c(const Complex *);
Pure DComplex CDECL __NAGf90_atan_dc(const DComplex *);
Pure __NAGf90_HComplex CDECL __NAGf90_atan_hc(__NAGf90_HComplex);
Pure Complex CDECL __NAGf90_atanh_c(const Complex *);
Pure DComplex CDECL __NAGf90_atanh_dc(const DComplex *);
Pure __NAGf90_HComplex CDECL __NAGf90_atanh_hc(__NAGf90_HComplex);
Pure Complex CDECL __NAGf90_cos_c(const Complex *);
Pure DComplex CDECL __NAGf90_cos_dc(const DComplex *);
Pure __NAGf90_HComplex CDECL __NAGf90_cos_hc(__NAGf90_HComplex);
Pure __NAGf90_HComplex CDECL __NAGf90_cosh_hc(__NAGf90_HComplex);
Pure Complex CDECL __NAGf90_cosh_c(const Complex *);
Pure DComplex CDECL __NAGf90_cosh_dc(const DComplex *);
Pure Complex CDECL __NAGf90_exp_c(const Complex *);
Pure DComplex CDECL __NAGf90_exp_dc(const DComplex *);
Pure __NAGf90_HComplex CDECL __NAGf90_exp_hc(__NAGf90_HComplex);
Pure Complex CDECL __NAGf90_log_c(const Complex *);
Pure DComplex CDECL __NAGf90_log_dc(const DComplex *);
Pure __NAGf90_HComplex CDECL __NAGf90_log_hc(__NAGf90_HComplex);
Pure Complex CDECL __NAGf90_sin_c(const Complex *);
Pure DComplex CDECL __NAGf90_sin_dc(const DComplex *);
Pure __NAGf90_HComplex CDECL __NAGf90_sin_hc(__NAGf90_HComplex);
Pure __NAGf90_HComplex CDECL __NAGf90_sinh_hc(__NAGf90_HComplex);
Pure Complex CDECL __NAGf90_sinh_c(const Complex *);
Pure DComplex CDECL __NAGf90_sinh_dc(const DComplex *);
Pure Complex CDECL __NAGf90_sqrt_c(const Complex *);
Pure DComplex CDECL __NAGf90_sqrt_dc(const DComplex *);
Pure __NAGf90_HComplex CDECL __NAGf90_sqrt_hc(__NAGf90_HComplex);
Pure __NAGf90_HComplex CDECL __NAGf90_tan_hc(__NAGf90_HComplex);
Pure __NAGf90_HComplex CDECL __NAGf90_tanh_hc(__NAGf90_HComplex);
Pure Complex CDECL __NAGf90_tan_c(const Complex *);
Pure DComplex CDECL __NAGf90_tan_dc(const DComplex *);
Pure Complex CDECL __NAGf90_tanh_c(const Complex *);
Pure DComplex CDECL __NAGf90_tanh_dc(const DComplex *);
#ifdef NATIVE_QUADR
QReal CDECL __NAGf90_abs_qc(const QComplex *);
QComplex CDECL __NAGf90_acos_qc(const QComplex *);
QComplex CDECL __NAGf90_acosh_qc(const QComplex *);
QComplex CDECL __NAGf90_asin_qc(const QComplex *);
QComplex CDECL __NAGf90_asinh_qc(const QComplex *);
QComplex CDECL __NAGf90_atan_qc(const QComplex *);
QComplex CDECL __NAGf90_atanh_qc(const QComplex *);
void CDECL __NAGf90_bessel_jn1n2_q(INT64 n164,INT64 n264,QReal x,QReal *y);
void CDECL __NAGf90_bessel_yn1n2_q(INT64 n164,INT64 n264,QReal x,QReal *y);
QComplex CDECL __NAGf90_cos_qc(const QComplex *);
QComplex CDECL __NAGf90_cosh_qc(const QComplex *);
VPure QReal CDECL __NAGf90_erf_q(QReal);
VPure QReal CDECL __NAGf90_erfc_q(QReal);
VPure QReal CDECL __NAGf90_erfc_scaled_q(QReal);
QComplex CDECL __NAGf90_exp_qc(const QComplex *);
Integer3 CDECL __NAGf90_exponent_q(const QReal *);
QReal CDECL __NAGf90_hypot_q(const QReal x, const QReal y);
QComplex CDECL __NAGf90_log_qc(const QComplex *);
QReal CDECL __NAGf90_nearest_q(QReal,QReal);
Pure QReal CDECL __NAGf90_norm2_q(int,const __NAGf90_Dope *);
Pure QReal CDECL __NAGf90_rrspacing_q(const QReal*);
QReal CDECL __NAGf90_set_exponent_q(QReal,Integer4);
QComplex CDECL __NAGf90_sin_qc(const QComplex *);
QComplex CDECL __NAGf90_sinh_qc(const QComplex *);
Pure QReal CDECL __NAGf90_spacing_q(const QReal *);
QComplex CDECL __NAGf90_sqrt_qc(const QComplex *);
QComplex CDECL __NAGf90_tan_qc(const QComplex *);
QComplex CDECL __NAGf90_tanh_qc(const QComplex *);
#endif

#ifdef Z9_HEX
double __NAGf90_checked_dpowi4(double x,Integer4 y,int *ifailp);
float __NAGf90_checked_fpowi4(float x,Integer4 y,int *ifailp);
static inline float __NAGf90_round_d_to_r(double d)
{
  UINT64 i = *(UINT64 *)&d;
  UINT32 r = i>>32;
  if (i&0x80000000 && (r&0x7fffffff)!=0x7fffffff) r++;
  return *(float*)&r;
}
#endif

#if defined(IBMZOS)
extern Char __NAGf90_achar[256];
extern Integer3 __NAGf90_iachar[256];
int __NAGf90_ascii_charcmp(const Char *a,const Char *b,Chrlen alen,Chrlen blen);
#endif

/*
 * Half-precision support.
 */
__NAGf90_HReal __NAGf90_float_to_HReal(float f);
float __NAGf90_HReal_to_float(__NAGf90_HReal x);
int __NAGf90_HReal_to_int(__NAGf90_HReal x);

#endif /* LIBFM_H_INCLUDED */
