! iso_fortran_env.f90
!
! Standard intrinsic module ISO_FORTRAN_ENV
!
! Copyright 2004-2025 The Numerical Algorithms Group Ltd., Oxford, U.K.
!
! Release 5.1: 1.3, 06/08/30
!
! Release 5.2: iso_fortran_env.f90 1 2009-12-02 02:54:28Z Malcolm Cohen
!
! Release 5.3: iso_fortran_env.f90 1592 2011-09-21 04:24:45Z Malcolm Cohen
!
! Tozai: iso_fortran_env.f90 4880 2015-10-11 12:57:23Z Malcolm Cohen
!
! Chiyoda: iso_fortran_env.f90 6046 2017-10-21 10:02:45Z Malcolm Cohen
!
! Yurakucho: $Id: iso_fortran_env.f90 10279 2025-06-12 05:12:05Z Malcolm Cohen $
!
Module,Intrinsic :: Iso_Fortran_Env
  Implicit None
  Intrinsic :: Bit_Size,Dim,Kind,Merge,Null,Selected_Char_Kind,Selected_Int_Kind, &
               Selected_Real_Kind,Size
  Private :: Bit_Size,Dim,Kind,Merge,Null,Selected_Char_Kind,Selected_Int_Kind, &
             Selected_Real_Kind,Size
  !
  ! Storage unit sizes in bits
  !
  Integer,Parameter :: character_storage_size = 8
  Integer,Parameter :: numeric_storage_size = Bit_Size(0)
  !
  ! Standard i/o unit numbers
  !
  Integer,Parameter :: error_unit = 0
  Integer,Parameter :: input_unit = 5
  Integer,Parameter :: output_unit = 6
  !
  ! The unit of measurement for RECL= in OPEN/INQUIRE (in bits).
  !
  Integer,Parameter :: file_storage_size = 8
  !
  ! IOSTAT return values (a subset of those in f90_iostat, and iostat_eof
  !                       is called iostat_end).
  !
  Integer,Parameter :: iostat_end = -1
  Integer,Parameter :: iostat_eor = -2
  Integer,Parameter :: iostat_inquire_internal_unit = 242
  !
  ! STAT= values.
  !
  Integer,Parameter :: stat_locked = 310
  Integer,Parameter :: stat_unlocked = 311
  Integer,Parameter :: stat_locked_other_image = 312
  Integer,Parameter :: stat_unlocked_failed_image = 313
  Integer,Parameter :: stat_failed_image = 314
  Integer,Parameter :: stat_stopped_image = 315
  !
  ! Fortran 2008: Constants for specific kinds.
  !
  Integer,Parameter :: int8 = Selected_Int_Kind(2)
  Integer,Parameter :: int16 = Selected_Int_Kind(4)
  Integer,Parameter :: int32 = Selected_Int_Kind(9)
  Integer,Parameter :: int64 = Selected_Int_Kind(18)
  Integer,Parameter :: real32 = Selected_Real_Kind(6)
  Integer,Parameter :: real16 = Merge(-1,Selected_Real_Kind(3),Selected_Real_Kind(3)==real32)
  Integer,Parameter :: real64 = Selected_Real_Kind(15)
  Integer,Private,Parameter :: trueq = Dim(Selected_Real_Kind(33,4900),0)
  Integer,Private,Parameter :: ddq = Dim(Selected_Real_Kind(31,291),0)
  Integer,Private,Parameter :: real64x2 = Merge(tsource=ddq,fsource=-1, &
                                                mask=(ddq>0 .And. ddq/=trueq))
  ! Prefer IEEE-compliant 128-bit-real over double-double if both available.
  Integer,Parameter :: real128 = Merge(tsource=trueq,fsource=real64x2, &
                                       mask=trueq>0)
  !
  ! Fortran 2008: Lists of supported kinds.
  !
  Integer,Parameter :: character_kinds(4) = [ Kind('A'), &
                                              Selected_Char_Kind('JIS_0213'), &
                                              Selected_Char_Kind('UCS_2'), &
                                              Selected_Char_Kind('ISO_10646') ]
  Integer,Parameter :: integer_kinds(4) = [ int8,int16,int32,int64 ]
  Integer,Parameter :: logical_kinds(4) = Merge( (integer_kinds), &
                                                 [ 201,202,203,204 ], &
                                                 Kind(.True.)==Kind(13) )
  Integer,Parameter :: real_kinds(4) = [ real16,real32,real64,real128 ]
  Interface compiler_version
    Module Procedure hidden_compiler_version
  End Interface
  Private hidden_compiler_version
  Interface compiler_options
    Module Procedure hidden_compiler_options
  End Interface
  Private hidden_compiler_options
  Integer,Private :: compiler_options_len = 999
  Type,Private :: ptr
    Real,Pointer :: rp
  End Type
  Type(ptr),Private,Parameter :: p = ptr(Null())
  Integer,Parameter :: atomic_int_kind = Merge(int64,int32, &
                                               Size(Transfer(p,[0_int32]))==2)
  Integer,Parameter :: atomic_logical_kind = Merge((logical_kinds(4)), &
                                                   (logical_kinds(3)), &
                                                   atomic_int_kind==int64)
  Integer,Parameter :: initial_team = -1, parent_team = -2, current_team = -3
  Type event_type
    Private
    Integer(atomic_int_kind) :: event_count = 0
    Character(:),Pointer :: waiting_filename => Null()
    Integer,Pointer :: os_event => Null()
    Integer(int32) :: waiting_line = 0
  End Type
  Type lock_type
    Private
    ! No component is allocatable or a pointer.
    Logical(atomic_logical_kind) :: locked = .False.
    Logical(atomic_logical_kind) :: checking_for_locking_image_failure = .False.
    Integer(int32) :: locked_by_image = 0, locked_by_line = 0
    Character(100) :: locked_by_file = ''
  End Type
  Type team_type
    Private
    Integer(int64) :: global_team_id = 0
    Integer(int64) :: parent_global_team_id = 0
    Integer(int64) :: team_number = -1
    Integer,Pointer :: fake_team_pointer => Null()
    Logical(Merge(203,int32,Kind(0)/=Kind(.False.))) :: valid = .False.
    Integer(int32) :: created_on_image = 0
  End Type
Contains
  Pure Function hidden_compiler_version() Result(r)
    Character(Len('NAG Fortran Compiler Release 7.1(Hanzomon) Build 0000')) r
    r = 'NAG Fortran Compiler Release 7.1(Hanzomon) Build 0000'
  End Function
  Pure Function hidden_compiler_options() Result(r)
    Character(compiler_options_len) r
    r = 'Whatever'
  End Function
End Module
