!  f90_kind.f90
!
!  Module defining the KIND numbers for the NAG Fortran Compiler.
!
!  Copyright 1991-2018 The Numerical Algorithms Group Ltd., Oxford, U.K.
!
!  Malcolm Cohen, Robert Iles, June 1991
!
!  Release 3: 1.1, 98/06/23
!
!  Release 4: 1.1, 99/12/20
!
!  Release 5.1: 1.3, 06/05/25
!
!  Release 5.2: f90_kind.f90 1 2009-12-02 02:54:28Z Malcolm Cohen
!
!  Release 5.3: f90_kind.f90 1656 2011-10-06 02:18:21Z Malcolm Cohen
!
!  Hibiya: f90_kind.f90 3780 2014-07-02 04:54:10Z Malcolm Cohen
!
!  Chiyoda: f90_kind.f90 5322 2016-07-31 06:02:46Z Malcolm Cohen
!
! Yurakucho: $Id: f90_kind.f90 6517 2018-09-03 09:02:14Z Malcolm Cohen $
!
Module,Intrinsic :: f90_kind
!
! These constants are obtained from ISO_FORTRAN_ENV in Fortran 2008.
!
    Use,Intrinsic :: Iso_Fortran_Env, &
                     Only:int8,int16,int32,int64,real16,real32,real64,real128,logical_kinds
!
! Hide the one we do not want to export.
!
    Private :: logical_kinds
!
! Hide the intrinsic functions we use internally.
!
    Intrinsic :: Dim,Kind,Merge,Precision,Selected_Char_Kind,Selected_Real_Kind
    Private :: Dim,Kind,Merge,Precision,Selected_Char_Kind,Selected_Real_Kind
!
! Indicator that the KIND= is not available for this compiler/host
    Integer,Parameter :: not_available = -1  
!
! Real and Complex numbers
!   Single precision
    Integer,Parameter :: single  = Kind(0.0)
!   Double precision
    Integer,Parameter :: double  = Kind(0.0d0)
!   Quadruple precision
    Integer,Parameter :: quad    = Selected_Real_Kind(Precision(1._double)*2-5)
!
! Work out "quad" situation vis-a-vis real128 and real64x2 privately.
! ("quad" is affected by use of the -double option!)
!
    Integer,Private,Parameter :: trueq = Dim(Selected_Real_Kind(33,4900),0)
    Integer,Private,Parameter :: ddq = Dim(Selected_Real_Kind(31,291),0)
!
!   Now ddq is 0 or the ddquad kind (if it exists) or the true quad kind,
!   and trueq is 0 or the true quad kind.  We use both these below.
!
! Real and Complex numbers
!   Two eight byte reals forming a quad
    Integer,Parameter :: real64x2  = Merge(tsource=ddq,fsource=-1, &
                                          mask=(ddq>0 .And. ddq/=trueq))
!
! Logical values
!   Single byte logical
    Integer,Parameter :: byte      = logical_kinds(1)
!   Two byte logical
    Integer,Parameter :: twobyte   = logical_kinds(2)
!   Four byte logical
    Integer,Parameter :: word      = logical_kinds(3)
!   Eight byte logical
    Integer,Parameter :: logical64 = logical_kinds(4)
!
! Character kinds
!   Normal single byte character (ASCII sequence)
    Integer,Parameter :: ascii   = Selected_Char_Kind('ASCII')
!   Japanese (JIS X 0213:2004) characters.
    Integer,Parameter :: jis = Selected_Char_Kind('JIS_0213')
!   Unicode 2-byte characters.
    Integer,Parameter :: ucs2 = Selected_Char_Kind('UCS_2')
!   Full ISO-10646 characters.
    Integer,Parameter :: ucs4 = Selected_Char_Kind('ISO_10646')
End Module f90_kind
