/* rts:ISO_Fortran_binding.h
 *
 * Copyright 2021 The Numerical Algorithms Group Ltd., Oxford, U.K.
 *
 * $Id: ISO_Fortran_binding.h 8704 2021-12-01 06:09:37Z Malcolm Cohen $
 */

#ifndef CFI_ISO_Fortran_binding_h_INCLUDED
#define CFI_ISO_Fortran_binding_h_INCLUDED

#include <stddef.h>
#include <stdint.h>

#define CFI_VERSION 7100
#define CFI_MAX_RANK 31

typedef int CFI_attribute_t;

#define CFI_attribute_pointer 0x20
#define CFI_attribute_allocatable 0x400
#define CFI_attribute_other 1

typedef int CFI_type_t;

#define CFI_type_signed_char 1
#define CFI_type_short 2
#define CFI_type_int 3
#define CFI_type_long (sizeof(long)==sizeof(int) ? CFI_type_int : CFI_type_int64_t)
#define CFI_type_long_long (sizeof(long)==sizeof(int64_t) ? CFI_type_int64_t : -1)
#define CFI_type_size_t (sizeof(size_t)==sizeof(int) ? CFI_type_int : sizeof(size_t)==sizeof(int64_t) ? CFI_type_int64_t : -2)
#define CFI_type_int8_t CFI_type_signed_char
#define CFI_type_int16_t CFI_type_short
#define CFI_type_int32_t CFI_type_int
#define CFI_type_int64_t 14
#define CFI_type_least8_t CFI_type_signed_char
#define CFI_type_least16_t CFI_type_short
#define CFI_type_least32_t CFI_type_int
#define CFI_type_least64_t CFI_type_int64_t
#define CFI_type_fast8_t CFI_type_signed_char
#define CFI_type_fast16_t CFI_type_short
#define CFI_type_fast32_t CFI_type_int
#define CFI_type_fast64_t CFI_type_int64_t
#define CFI_type_intmax_t (sizeof(intmax_t)==sizeof(int64_t) ? CFI_type_int64_t : -3)
#define CFI_type_intptr_t (sizeof(intptr_t)==sizeof(int) ? CFI_type_int : sizeof(intptr_t)==sizeof(int64_t) ? CFI_type_int64_t : -4)
#define CFI_type_ptrdiff_t (sizeof(ptrdiff_t)==sizeof(int) ? CFI_type_int : sizeof(ptrdiff_t)==sizeof(int64_t) ? CFI_type_int64_t : -5)
#define CFI_type_float 4
#define CFI_type_double 5
#define CFI_type_long_double -6
#define CFI_type_float_Complex 8
#define CFI_type_double_Complex 9
#define CFI_type_long_double_Complex -7
#define CFI_type_Bool -8
#define CFI_type_char 10
#define CFI_type_cptr 0x1000
#define CFI_type_struct 0x1001
#define CFI_type_other 0x1002

typedef ptrdiff_t CFI_index_t;

typedef struct {
  CFI_index_t extent,sm,lower_bound;
} CFI_dim_t;

typedef int CFI_rank_t;

typedef struct {
  void *base_addr;
  size_t elem_len;
  int version;
  CFI_rank_t rank;
  CFI_type_t type;
  CFI_attribute_t attribute;
  size_t len,offset;
  int64_t *dtp;
  void *sig;
  void *reserved;
  int64_t ireserved;
  CFI_dim_t dim[];
} CFI_cdesc_t;

#define CFI_CDESC_T(_N) struct {\
  void *base_addr;\
  size_t elem_len;\
  int version;\
  CFI_rank_t rank;\
  CFI_type_t type;\
  CFI_attribute_t attribute;\
  size_t len,offset;\
  int64_t *dtp;\
  void *sig;\
  void *reserved;\
  int64_t ireserved;\
  CFI_dim_t dim[_N];\
}

#define CFI_SUCCESS 0
#define CFI_ERROR_NULL_DESCRIPTOR   0x0fffffff
#define CFI_ERROR_UNKNOWN_ERROR     0x10000000
#define CFI_ERROR_BASE_ADDR_NULL    0x10000001
#define CFI_ERROR_BASE_ADDR_NOT_NULL 0x10000002
#define CFI_INVALID_ELEM_LEN        0x10000003
#define CFI_INVALID_RANK            0x10000004
#define CFI_INVALID_TYPE            0x10000005
#define CFI_INVALID_ATTRIBUTE       0x10000006
#define CFI_INVALID_EXTENT          0x10000007
#define CFI_INVALID_DESCRIPTOR      0x10000008
#define CFI_ERROR_MEM_ALLOCATION    0x10000009
#define CFI_ERROR_OUT_OF_BOUNDS     0x1000000A

#define CFI_address __NAGf90_CFI_address
#define CFI_allocate __NAGf90_CFI_allocate
#define CFI_deallocate __NAGf90_CFI_deallocate
#define CFI_establish __NAGf90_CFI_establish
#define CFI_is_contiguous __NAGf90_CFI_is_contiguous
#define CFI_section __NAGf90_CFI_section
#define CFI_select_part __NAGf90_CFI_select_part
#define CFI_setpointer __NAGf90_CFI_setpointer

extern void *__NAGf90_CFI_address(const CFI_cdesc_t *dv, const CFI_index_t subscripts[]);
extern int __NAGf90_CFI_allocate(CFI_cdesc_t *dv, const CFI_index_t lower_bounds[],
                        const CFI_index_t upper_bounds[], size_t elem_len);
extern int __NAGf90_CFI_deallocate(CFI_cdesc_t *dv);
extern int __NAGf90_CFI_establish(CFI_cdesc_t *dv, void *base_addr, CFI_attribute_t attribute,
                                  CFI_type_t type, size_t elem_len, CFI_rank_t rank,
                                  const CFI_index_t extents[]);
extern int __NAGf90_CFI_is_contiguous(const CFI_cdesc_t * dv);
extern int __NAGf90_CFI_section(CFI_cdesc_t *result, const CFI_cdesc_t *source,
                                const CFI_index_t lower_bounds[], const CFI_index_t upper_bounds[],
                                const CFI_index_t strides[]);
extern int __NAGf90_CFI_select_part(CFI_cdesc_t *result, const CFI_cdesc_t *source, size_t displacement,
                                    size_t elem_len);
extern int __NAGf90_CFI_setpointer(CFI_cdesc_t *result, CFI_cdesc_t *source,
                                   const CFI_index_t lower_bounds[]);

#endif
